@if (Auth::guard('admin')->user()->role_id != 0)

    @permission('Menu Builder')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.gs.menubuilder') }}">
                <i class="fas fa-compass"></i>
                <span>{{ __('Menu Builder') }}</span></a>
        </li>
    @endpermission

    @permission('Manage Customers')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#customer" aria-expanded="true"
                aria-controls="collapseTable">
                <i class="fas fa-user"></i>
                <span>{{ __('Manage Customers') }}</span>
            </a>
            <div id="customer" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('User List')
                        <a class="collapse-item" href="{{ route('admin.user.index') }}">{{ __('User List') }}</a>
                    @endpermission
                    @permission('Referral Bonus')
                        <a class="collapse-item" href="{{ route('admin.user.bonus') }}">{{ __('Referral Bonus') }}</a>
                    @endpermission
                    @permission('Admin Transaction')
                        <a class="collapse-item"
                            href="{{ route('admin.user.admin.transaction') }}">{{ __('Admin Transaction') }}</a>
                    @endpermission

                    @permission('User Logs')
                        <a class="collapse-item" href="{{ route('admin.user.logs') }}">{{ __('User Logs') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Manage User KYC')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#customer_kyc"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-user"></i>
                <span>{{ __('Manage User KYC') }}</span>
            </a>
            <div id="customer_kyc" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('User KYC Info')
                        <a class="collapse-item" href="{{ route('admin.kyc.info', 'user') }}">{{ __('User KYC Info') }}</a>
                    @endpermission
                    @permission('User KYC Modules')
                        <a class="collapse-item" href="{{ route('admin.manage.module') }}">{{ __('User KYC Modules') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Loan Management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#loan" aria-expanded="true"
                aria-controls="collapseTable">
                <i class="fas fa-cash-register"></i>
                <span>{{ __('Loan Management') }}</span>
            </a>
            <div id="loan" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Loan Plans')
                        <a class="collapse-item" href="{{ route('admin.loan.plan.index') }}">{{ __('Loan Plans') }}</a>
                    @endpermission
                    @permission('All Loans')
                        <a class="collapse-item" href="{{ route('admin.loan.index') }}">{{ __('All Loans') }}</a>
                    @endpermission
                    @permission('Pending Loan')
                        <a class="collapse-item" href="{{ route('admin.loan.pending') }}">{{ __('Pending Loan') }}</a>
                    @endpermission
                    @permission('Running Loan')
                        <a class="collapse-item" href="{{ route('admin.loan.running') }}">{{ __('Running Loan') }}</a>
                    @endpermission
                    @permission('Paid Loan')
                        <a class="collapse-item" href="{{ route('admin.loan.completed') }}">{{ __('Paid Loan') }}</a>
                    @endpermission
                    @permission('Rejected Loan')
                        <a class="collapse-item" href="{{ route('admin.loan.rejected') }}">{{ __('Rejected Loan') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('DPS Management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#dps" aria-expanded="true"
                aria-controls="collapseTable">
                <i class="fas fa-warehouse"></i>
                <span>{{ __('DPS Management') }}</span>
            </a>
            <div id="dps" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Dps Plans')
                        <a class="collapse-item" href="{{ route('admin.dps.plan.index') }}">{{ __('Dps Plans') }}</a>
                    @endpermission
                    @permission('All Dps')
                        <a class="collapse-item" href="{{ route('admin.dps.index') }}">{{ __('All Dps') }}</a>
                    @endpermission
                    @permission('Running Dps')
                        <a class="collapse-item" href="{{ route('admin.dps.running') }}">{{ __('Running Dps') }}</a>
                    @endpermission
                    @permission('Matured Dps')
                        <a class="collapse-item" href="{{ route('admin.dps.matured') }}">{{ __('Matured Dps') }}</a>
                    @endpermission
                    @permission('Closed Dps')
                        <a class="collapse-item" href="{{ route('admin.dps.closed') }}">{{ __('Closed Dps') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('FDR Management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#fdr" aria-expanded="true"
                aria-controls="collapseTable">
                <i class="fas fa-user-shield"></i>
                <span>{{ __('FDR Management') }}</span>
            </a>
            <div id="fdr" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Fdr Plans')
                        <a class="collapse-item" href="{{ route('admin.fdr.plan.index') }}">{{ __('Fdr Plans') }}</a>
                    @endpermission
                    @permission('All Fdr')
                        <a class="collapse-item" href="{{ route('admin.fdr.index') }}">{{ __('All Fdr') }}</a>
                    @endpermission
                    @permission('Running Fdr')
                        <a class="collapse-item" href="{{ route('admin.fdr.running') }}">{{ __('Running Fdr') }}</a>
                    @endpermission
                    @permission('Closed Fdr')
                        <a class="collapse-item" href="{{ route('admin.fdr.closed') }}">{{ __('Closed Fdr') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Bank Plans')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.bank.plan.index') }}">
                <i class="fas fa-landmark"></i>
                <span>{{ __('Bank Plans') }}</span>
            </a>
        </li>
    @endpermission

    @permission('Other Banks')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.other.banks.index') }}">
                <i class="fas fa-landmark"></i>
                <span>{{ __('Other Banks') }}</span>
            </a>
        </li>
    @endpermission

    @permission('Money Transfer')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#moneytransfer"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-exchange-alt"></i>
                <span>{{ __('Money Transfer') }}</span>
            </a>
            <div id="moneytransfer" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">

                    @permission('Own Bank Transfer')
                        <a class="collapse-item"
                            href="{{ route('admin.own.banks.transfer.index') }}">{{ __('Own Bank Transfer') }}</a>
                    @endpermission
                    @permission('Other Bank Transfer')
                        <a class="collapse-item"
                            href="{{ route('admin.other.banks.transfer.index') }}">{{ __('Other Bank Transfer') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Manage Wire Transfer')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#wiretransfer"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-wallet"></i>
                <span>{{ __('Manage Wire Transfer') }}</span>
            </a>
            <div id="wiretransfer" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Wire Transfer Bank')
                        <a class="collapse-item"
                            href="{{ route('admin.wire.transfer.banks.index') }}">{{ __('Wire Transfer Bank') }}</a>
                    @endpermission
                    @permission('Wire Transfers')
                        <a class="collapse-item"
                            href="{{ route('admin.wire.transfer.index') }}">{{ __('Wire Transfers') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Request Money')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#requestmoney"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-donate"></i>
                <span>{{ __('Request Money') }}</span>
            </a>
            <div id="requestmoney" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('All Money Request')
                        <a class="collapse-item" href="{{ route('admin.request.money') }}">{{ __('All Money Request') }}</a>
                    @endpermission
                    @permission('Money Request Setting')
                        <a class="collapse-item"
                            href="{{ route('admin.request.setting.create') }}">{{ __('Money Request Setting') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Transactions')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.transactions.index') }}">
                <i class="fas fa-chart-line"></i>
                <span>{{ __('Transactions') }}</span>
            </a>
        </li>
    @endpermission

    @permission('Deposit Requests')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.deposits.index') }}">
                <i class="fas fa-piggy-bank"></i>
                <span>{{ __('Deposit Requests') }}</span>
                @php($depositsCount = DB::table('deposits')->where('status', 'pending')->count())
                @if ($depositsCount > 0)
                    <span class="badge badge-sm badge-danger badge-counter">{{ $depositsCount }}</span>
                @endif
            </a>
        </li>
    @endpermission

    @permission('Withdraw Requests')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.withdraw.index') }}">
                <i class="fas fa-piggy-bank"></i>
                <span>{{ __('Withdraw Requests') }}</span>
                @php($withdrawsCount = DB::table('withdraws')->where('status', 'pending')->count())
                @if ($withdrawsCount > 0)
                    <span class="badge badge-sm badge-danger badge-counter">{{ $depositsCount }}</span>
                @endif
            </a>

        </li>
    @endpermission

    @permission('Payment Settings')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#payment_gateways"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-fw fa-newspaper"></i>
                <span>{{ __('Payment Settings') }}</span>
            </a>
            <div id="payment_gateways" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Currencies')
                        <a class="collapse-item" href="{{ route('admin.currency.index') }}">{{ __('Currencies') }}</a>
                    @endpermission
                    @permission('Gateways / Funds')
                        <a class="collapse-item" href="{{ route('admin.payment.index') }}">{{ __('Gateways / Funds') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission



    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#message"
            aria-expanded="true" aria-controls="collapseTable">
            <i class="fas fa-vote-yea"></i>
            <span>{{ __('Messages') }}</span>
        </a>
        <div id="message" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                @permission('All Messages')
                    <a class="collapse-item" href="{{ route('admin.user.message') }}">{{ __('Messages') }}</a>
                @endpermission
                @permission('Manage Message Category')
                    <a class="collapse-item"
                        href="{{ route('admin.gs.message.category') }}">{{ __('Message  Category') }}</a>
                @endpermission
            </div>
        </div>
    </li>

    @permission('Reports')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#reports_menus"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-chart-line"></i>
                <span>{{ __('Reports') }}</span>
            </a>
            <div id="reports_menus" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item"
                        href="{{ route('admin.reports.profit-from-charge') }}">{{ __('Profit From Charges') }}</a>
                </div>
            </div>
        </li>
    @endpermission

    @permission('Manage Blogs')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#blog"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-fw fa-newspaper"></i>
                <span>{{ __('Manage Blogs') }}</span>
            </a>
            <div id="blog" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item" href="{{ route('admin.cblog.index') }}">{{ __('Categories') }}</a>
                    <a class="collapse-item" href="{{ route('admin.blog.index') }}">{{ __('Posts') }}</a>
                </div>
            </div>
        </li>
    @endpermission

    @permission('General Setting')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTable1"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-fw fa-cogs"></i>
                <span>{{ __('General Settings') }}</span>
            </a>
            <div id="collapseTable1" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Logo')
                        <a class="collapse-item" href="{{ route('admin.gs.logo') }}">{{ __('Logo') }}</a>
                    @endpermission
                    @permission('Favicon')
                        <a class="collapse-item" href="{{ route('admin.gs.fav') }}">{{ __('Favicon') }}</a>
                    @endpermission
                    @permission('Loader')
                        <a class="collapse-item" href="{{ route('admin.gs.load') }}">{{ __('Loader') }}</a>
                    @endpermission
                    @permission('Breadcumb Banner')
                        <a class="collapse-item" href="{{ route('admin.gs.breadcumb') }}">{{ __('Breadcumb Banner') }}</a>
                    @endpermission
                    @permission('Website Contents')
                        <a class="collapse-item" href="{{ route('admin.gs.contents') }}">{{ __('Website Contents') }}</a>
                    @endpermission
                    @permission('User Modules')
                        <a class="collapse-item" href="{{ route('admin.gs.user.modules') }}">{{ __('User Modules') }}</a>
                    @endpermission
                    @permission('Error Banner')
                        <a class="collapse-item" href="{{ route('admin.gs.error.banner') }}">{{ __('Error Banner') }}</a>
                    @endpermission
                    @permission('Notice Add')
                        <a class="collapse-item" href="{{ route('admin.gs.notice') }}">{{ __('Notice Add') }}</a>
                    @endpermission
                    @permission('Maintenance')
                        <a class="collapse-item" href="{{ route('maintenance-mode') }}">{{ __('Maintenance') }}</a>
                    @endpermission
                    @permission('Tawk Script')
                        <a class="collapse-item" href="{{ route('tawk.script') }}">{{ __('Live Chat') }}</a>
                    @endpermission
                    @permission('Block Ip Data')
                        <a class="collapse-item" href="{{ route('admin.gs.blockip') }}">{{ __('Block IPs') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Homepage Manage')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#homepage"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-igloo"></i>
                <span>{{ __('Home Page Manage') }}</span>
            </a>
            <div id="homepage" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item" href="{{ route('admin.ps.hero') }}">{{ __('Hero Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.feature.index') }}">{{ __('Feature Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.ps.about') }}">{{ __('About Us Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.service.index') }}">{{ __('Service Section') }}</a>
                    <a class="collapse-item"
                        href="{{ route('admin.account.process.index') }}">{{ __('Account Register Process') }}</a>
                    <a class="collapse-item" href="{{ route('admin.ps.account') }}">{{ __('Strategy Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.ps.apps') }}">{{ __('Apps Section') }}</a>
                    <a class="collapse-item"
                        href="{{ route('admin.review.index') }}">{{ __('Testimonial Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.counter.index') }}">{{ __('Counter Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.ps.quick') }}">{{ __('Quick Start Section') }}</a>
                    <a class="collapse-item" href="{{ route('admin.ps.heading') }}">{{ __('Section Heading') }}</a>
                </div>
            </div>
        </li>
    @endpermission

    @permission('Email Setting')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#email_settings"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fa fa-envelope"></i>
                <span>{{ __('Email Settings') }}</span>
            </a>
            <div id="email_settings" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    @permission('Email Template')
                        <a class="collapse-item" href="{{ route('admin.mail.index') }}">{{ __('Email Template') }}</a>
                    @endpermission
                    @permission('Email Configuration')
                        <a class="collapse-item"
                            href="{{ route('admin.mail.config') }}">{{ __('Email Configurations') }}</a>
                    @endpermission
                    @permission('Group Email')
                        <a class="collapse-item" href="{{ route('admin.group.show') }}">{{ __('Group Email') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Sms Setup')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#sms_settings"
                aria-expanded="true" aria-controls="collapseTable">
                {{-- <i class="fa fa-envelope"></i> --}}
                <i class="fa fa-comment"></i>

                <span>{{ __('Sms Settings') }}</span>
            </a>
            <div id="sms_settings" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {{-- <a class="collapse-item" href="{{ route('admin.gs.twilio') }}">{{ __('Twilio Sms') }}</a>
            <a class="collapse-item" href="{{ route('admin.gs.nexmo') }}">{{ __('Nexmo Sms') }}</a> --}}
                    <a class="collapse-item" href="{{ route('admin.gs.bulksmsbd') }}">{{ __('BulkBd Sms') }}</a>
                    <a class="collapse-item" href="{{ route('admin.gs.d7networks') }}">{{ __('D7 Network Sms') }}</a>

                </div>
            </div>
        </li>
    @endpermission

    @permission('Manage Roles')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.role.index') }}">
                <i class="fa fa-crop"></i>
                <span>{{ __('Manage Roles') }}</span></a>
        </li>
    @endpermission

    @permission('Manage Staff')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.staff.index') }}">
                <i class="fas fa-fw fa-users"></i>
                <span>{{ __('Manage Staff') }}</span></a>
        </li>
    @endpermission

    @permission('Manage KYC Form')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.manage.kyc.user', 'user') }}">
                <i class="fas fa-child"></i>
                <span>{{ __('Manage KYC Form') }}</span></a>
        </li>
    @endpermission

    @permission('Language Manage')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#langs"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-language"></i>
                <span>{{ __('Language Manage') }}</span>
            </a>
            <div id="langs" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item" href="{{ route('admin.lang.index') }}">{{ __('Website Language') }}</a>
                    {{-- <a class="collapse-item" href="{{route('admin.tlang.index')}}">{{ __('Admin Panel Language') }}</a> --}}
                </div>
            </div>
        </li>
    @endpermission

    @permission('Fonts')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.font.index') }}">
                <i class="fas fa-font"></i>
                <span>{{ __('Fonts') }}</span></a>
        </li>
    @endpermission

    @permission('Menupage Setting')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#menu"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-fw fa-edit"></i>
                <span>{{ __('Menu Page Settings') }}</span>
            </a>
            <div id="menu" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item" href="{{ route('admin.ps.contact') }}">{{ __('Contact Us Page') }}</a>
                    <a class="collapse-item" href="{{ route('admin.page.index') }}">{{ __('Other Pages') }}</a>
                    <a class="collapse-item" href="{{ route('admin.faq.index') }}">{{ __('FAQ Page') }}</a>
                </div>
            </div>
        </li>
    @endpermission

    @permission('Seo Tools')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#seoTools"
                aria-expanded="true" aria-controls="collapseTable">
                <i class="fas fa-wrench"></i>
                <span>{{ __('SEO Tools') }}</span>
            </a>
            <div id="seoTools" class="collapse" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <a class="collapse-item"
                        href="{{ route('admin.seotool.analytics') }}">{{ __('Google Analytics') }}</a>
                    <a class="collapse-item"
                        href="{{ route('admin.seotool.keywords') }}">{{ __('Website Meta Keywords') }}</a>
                    @permission('Social Links')
                        <a class="collapse-item" href="{{ route('admin.social.index') }}">{{ __('Social Links') }}</a>
                    @endpermission
                </div>
            </div>
        </li>
    @endpermission

    @permission('Sitemaps')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.sitemap.index') }}">
                <i class="fa fa-sitemap"></i>
                <span>{{ __('Sitemaps') }}</span></a>
        </li>
    @endpermission

    @permission('Subscribers')
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.subs.index') }}">
                <i class="fas fa-fw fa-users-cog"></i>
                <span>{{ __('Subscribers') }}</span></a>
        </li>
    @endpermission

@endif
