@fragment('enable-email-2fa')
    <form
        x-data="{
            enabled: {{ $user->email_2fa == 1 ? 'true' : 'false' }},
        }"
        id="enable_email_2fa_form"
        x-ref="enable_email_2fa_form"
        hx-trigger="submit"
        hx-post="?action=verify-email-otp"
        hx-target="#enable_email_2fa_form"
        hx-swap="outterHTML"
        @htmx:response-error="toastr.error('Failed to verify OTP')"
        @if(!$otpVerified && !$otpSent)
            x-init="toastr.error('OTP Verification failed. Please try again.')"
        @endif
        @if($otpSent)
            x-init="toastr.success('Verification code is sent to your email')"
        @endif
    >
        <div class="form-group mb-3">
            @csrf
            <div class="form-label text-muted">Verify OTP for 2FA via Email</div>
            <div class="input-group d-inline-flex">
                <input type="number" maxlength="6" name="otp" class="form-control form--control"
                       placeholder="Enter OTP"/>
                <button type="submit" class="btn btn-primary">Verify OTP</button>
            </div>
        </div>
    </form>
@endfragment
@fragment('disable-email-2fa')
    <form
        x-data="{
        enabled: {{ $user->email_2fa == 1 ? 'true' : 'false' }},
    }"
        id="enable_email_2fa_form"
        x-ref="enable_email_2fa_form"
        hx-trigger="submit"
        hx-post="?action=verify-email-otp&disable=1"
        hx-target="#enable_email_2fa_form"
        hx-swap="outterHTML"
        @htmx:response-error="toastr.error('Failed to verify OTP')"
        x-init="toastr.success('Verification code is sent to your email')"
    >
        <div class="form-group mb-3">
            @csrf
            <div class="form-label text-muted">Verify OTP for 2FA via Email</div>
            <div class="input-group d-inline-flex">
                <input type="number" maxlength="6" name="otp" class="form-control form--control"
                       placeholder="Enter OTP"/>
                <button type="submit" class="btn btn-primary">Verify OTP</button>
            </div>
        </div>
    </form>
@endfragment
@fragment('enable-email-2fa-form')
    <form
        x-data="{
            enabled: {{ $user->email_2fa == 1 ? 'true' : 'false' }},
        }"
        id="enable_email_2fa_form"
        x-ref="enable_email_2fa_form"
        @if($otpVerified) x-init="toastr.success('OTP verified 2FA {{$disabled ?'disabled':'enabled'}}.')" @endif
    >
        <div class="form-group mb-3">
            @csrf
            <div class="form-label text-muted">Enable/Disable 2FA via Email</div>
            <label
                class="form-check form-switch form-switch-lg d-inline-flex align-items-center gap-2">
                <input
                    type="checkbox"
                    class="form-check-input"
                    @checked($user->email_2fa == 1)
                    hx-trigger="change"
                    hx-post="?action={{$user->email_2fa == 1 ? 'disable-email-2fa' : 'enable-email-2fa'}}"
                    hx-target="#enable_email_2fa_form"
                    hx-swap="outterHTML"
                    @htmx:response-error="toastr.error('Failed to change status')"
                />
                <span class="form-check-label" x-text="enabled ? 'Enabled' : 'Disabled'">
                    {{ $user->email_2fa == 1 ? 'Enabled' : 'Disabled' }}
                </span>
            </label>
        </div>
    </form>
@endfragment
