<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    @if (isset($page->meta_tag) && isset($page->meta_description))
        <meta name="keywords" content="{{ $page->meta_tag }}">
        <meta name="description" content="{{ $page->meta_description }}">
    @elseif(isset($blog->meta_tag) && isset($blog->meta_description))
        <meta name="keywords" content="{{ $blog->meta_tag }}">
        <meta name="description" content="{{ $blog->meta_description }}">
    @else
        <meta name="keywords" content="{{ $seo->meta_keys }}">
        <meta name="description" content="{{ $seo->meta_description }}">
        <meta name="author" content="GeniusOcean">
    @endif


    <meta property="og:title" content="{{ $seo->social_title }}" />
    <meta property="og:description" content="{{ $seo->social_description }}" />
    <meta property="og:image" content="{{ asset('assets/images/' . $seo->logo) }}" />
    <meta property="og:url" content="{{ url()->current() }}" />

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $seo->social_title }}">
    <meta name="twitter:description" content="{{ $seo->social_description }}">
    <meta name="twitter:image" content="{{ asset('assets/images/' . $seo->logo) }}">
    <title>{{ $gs->title }}</title>

    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/lightbox.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/odometer.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/owl.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/main.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/toastr.min.css') }}">

    <link rel="stylesheet"
        href="{{ asset('assets/front/css/styles.php?color=' . str_replace('#', '', $gs->colors)) }}">

    @if ($default_font->font_value)
        <link href="https://fonts.googleapis.com/css?family={{ $default_font->font_value }}&display=swap"
            rel="stylesheet">
    @else
        <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">
    @endif

    @if ($default_font->font_family)
        <link rel="stylesheet" id="colorr"
            href="{{ asset('assets/front/css/font.php?font_familly=' . $default_font->font_family) }}">
    @else
        <link rel="stylesheet" id="colorr"
            href="{{ asset('assets/front/css/font.php?font_familly=' . 'Open Sans') }}">
    @endif

    @stack('css')
    <link rel="shortcut icon" href="{{ asset('assets/images/' . $gs->favicon) }}">

    @if (config('services.gtm.id'))
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '{{ config('services.gtm.id') }}');
        </script>
    @endif

    <!-- Meta Pixel Code -->
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ?
                    n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ config('services.facebook.pixel_id') }}');
        fbq('track', 'PageView');
    </script>
    <noscript>
        <img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ config('services.facebook.pixel_id') }}&ev=PageView&noscript=1" />
    </noscript>
    <!-- End Meta Pixel Code -->


</head>

<body>

    @if (config('services.gtm.id'))
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id={{ config('services.gtm.id') }}" height="0"
                width="0" style="display:none;visibility:hidden"></iframe>
        </noscript>
    @endif

    <!-- Overlayer -->
    <span class="toTopBtn">
        <i class="fas fa-angle-up"></i>
    </span>
    <div class="overlayer"></div>
    <div class="loader">
        <h2>
            <span class="let1">l</span>
            <span class="let2">o</span>
            <span class="let3">a</span>
            <span class="let4">d</span>
            <span class="let5">i</span>
            <span class="let6">n</span>
            <span class="let7">g</span>
        </h2>
    </div>
    <!-- Overlayer -->

    <!-- Header -->
    <header class="position-relative">
        <div class="navbar-top bg--title">
            <div class="container">
                @include('partials.front.navbar')
            </div>
        </div>
        <div class="navbar-bottom">
            <div class="container">
                @include('partials.front.nav')
            </div>
        </div>
    </header>
    <!-- Header -->

    @yield('content')

    <!-- Footer -->
    @include('partials.front.footer')
    <!-- Footer -->

    @include('cookie-consent::index')

    <!-- Modal -->
    <div class="modal fade" id="modal-apply">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg--section">
                    <h5 class="modal-title loan-title m-0">@lang('Basic')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('user.loan.amount') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="pt-3 pb-4">
                            <label for="amount" class="form-label">@lang('Amount')</label>
                            <div class="input-group input--group">
                                <input type="number" name="amount"
                                    class="form-group-input form-control form--control" placeholder="0.00"
                                    id="amount">
                                <button type="button" class="input-group-text">{{ $currency->name }}</button>
                            </div>
                            <input type="hidden" name="planId" id="planId" value="">
                        </div>
                    </div>
                    <div class="modal-footer bg--section">
                        <button type="button" class="btn shadow-none btn--danger"
                            data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn shadow-none btn--success">@lang('Proceed')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal -->

    <!-- Modal -->
    <div class="modal fade" id="modal-pension">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg--section">
                    <h5 class="modal-title loan-title m-0">@lang('Basic')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('user.fdr.amount') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="pt-3 pb-4">
                            <label for="amount" class="form-label">@lang('Amount')</label>
                            <div class="input-group input--group">
                                <input type="number" name="amount"
                                    class="form-group-input form-control form--control" placeholder="0.00"
                                    id="amount">
                                <button type="button" class="input-group-text">{{ $currency->name }}</button>
                            </div>
                            <input type="hidden" name="planId" id="fdrplan" value="">
                        </div>
                    </div>
                    <div class="modal-footer bg--section">
                        <button type="button" class="btn shadow-none btn--danger"
                            data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn shadow-none btn--success">@lang('Proceed')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal -->


    <script src="{{ asset('assets/front/js/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/viewport.jquery.js') }}"></script>
    <script src="{{ asset('assets/front/js/odometer.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/lightbox.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/owl.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/notify.js') }}"></script>
    <script src="{{ asset('assets/front/js/main.js') }}"></script>
    <script src="{{ asset('assets/front/js/custom.js') }}"></script>

    <script>
        'use strict';
        let mainurl = '{{ url('/') }}';
    </script>

    <script>
        'use strict';

        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('message') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("{{ session('error') }}");
        @endif

        @if (Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("{{ session('info') }}");
        @endif

        @if (Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("{{ session('warning') }}");
        @endif
    </script>

    <script>
        'use strict';

        $('.apply-loan').on('click', function() {
            let id = $(this).data('id');
            let title = $(this).data('title');

            $('#planId').val(id);
            $('.loan-title').text(title);
        });

        $('.apply-pension').on('click', function() {
            let id = $(this).data('id');
            let title = $(this).data('title');

            $('#fdrplan').val(id);
            $('.loan-title').text(title);
        });
    </script>
    @stack('js')
    @php
        $tawk = \App\Models\tawkScript::first();
    @endphp

    @if ($tawk && $tawk->whatsapp_tawk_enabled && $tawk->whatsapp_tawk_script)
        {!! $tawk->whatsapp_tawk_script !!}
        <script type="text/javascript">
            Tawk_API = Tawk_API || {};
            Tawk_API.onLoad = function() {
                var iframe = document.querySelector('iframe[title="chat widget"]');
                if (iframe) {
                    iframe.style.bottom = "84px";
                }
            };
        </script>
    @endif

    @if ($tawk && $tawk->messenger_tawk_enabled && $tawk->messenger_tawk_script)
        {!! $tawk->messenger_tawk_script !!}
        <script type="text/javascript">
            Tawk_API = Tawk_API || {};
            Tawk_API.onLoad = function() {
                var iframe = document.querySelector('iframe[title="chat widget"]');
                if (iframe) {
                    iframe.style.bottom = "150px";
                }
            };
        </script>
    @endif
</body>

</html>
