<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title>{{$gs->title}}</title>
    <link href="{{asset('assets/user/css/tabler.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('assets/user/css/tabler-vendors.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('assets/user/css/custom.css')}}" rel="stylesheet"/>
</head>
<body class=" border-top-wide border-primary d-flex flex-column">
<div class="page page-center">
    <div class="container-tight py-4">
        <div class="text-center">
            <div class="d-flex justify-content-center gap-3 mb-3">
                <div>
                    <img src="{{asset('assets/images/'.$gs->logo)}}" height="32" alt="Logo" class="payment-logo"/>
                </div>
                <div class="border-start"></div>
                <div>
                    <img src="{{$merchant->merchant_logo_url}}" height="32" alt="Logo" class="payment-logo"/>
                </div>
            </div>
        </div>
        <div class="card payment-card">
            <div class="card-body">
                <div
                    class="card-title border-bottom pb-2 d-flex align-items-center gap-2 justify-content-between">
                    <div class="d-flex align-items-center gap-2 text-truncate">
                        <span class="d-inline-block flex-grow-0 flex-shrink-0 border rounded-circle px-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 576 512"
                                 fill="currentColor" class="text-muted">
                                <path
                                    d="M547.6 103.8L490.3 13.1C485.2 5 476.1 0 466.4 0L109.6 0C99.9 0 90.8 5 85.7 13.1L28.3 103.8c-29.6 46.8-3.4 111.9 51.9 119.4c4 .5 8.1 .8 12.1 .8c26.1 0 49.3-11.4 65.2-29c15.9 17.6 39.1 29 65.2 29c26.1 0 49.3-11.4 65.2-29c15.9 17.6 39.1 29 65.2 29c26.2 0 49.3-11.4 65.2-29c16 17.6 39.1 29 65.2 29c4.1 0 8.1-.3 12.1-.8c55.5-7.4 81.8-72.5 52.1-119.4zM499.7 254.9c0 0 0 0-.1 0c-5.3 .7-10.7 1.1-16.2 1.1c-12.4 0-24.3-1.9-35.4-5.3L448 384l-320 0 0-133.4c-11.2 3.5-23.2 5.4-35.6 5.4c-5.5 0-11-.4-16.3-1.1l-.1 0c-4.1-.6-8.1-1.3-12-2.3L64 384l0 64c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-64 0-131.4c-4 1-8 1.8-12.3 2.3z"/>
                            </svg>
                        </span>
                        <span>{{ $merchant->user->name }}</span>
                        <small class="text-muted">- Online Payment</small>
                    </div>
                </div>
                <p>{{ $paymentRequest->description }}</p>

                <div class="border rounded-3 p-2">
                    <div class="text-center text-muted">Total Amount</div>
                    <div class="text-center text-h1">
                        <strong>{{ amount_format($paymentRequest->amount) }} {{ $paymentRequest->currency }}</strong>
                    </div>
                </div>
                @if($user?->id != $merchant->user_id)
                    <div class="text-center mt-3 mb-1">
                        <div class="h3 mb-0"><strong>Scan to pay</strong></div>
                        <small class="text-muted">Use this QR code to pay using your phone.</small>
                        <div class="text-center" style="min-height: 200px">
                            <img src="{{ $qrCodeUrl }}" alt="QR Code" class="img-fluid">
                        </div>
                    </div>

                    <div class="text-center mb-3">or</div>
                @endif
                <div class="text-center">
                    @auth
                        @if($user->id == $merchant->user_id)
                            <div class="text-danger mt-4 mb-4">
                                <strong>You can not to pay yourself.</strong>
                            </div>
                        @elseif($user->balance < $paymentRequest->amount)
                            <div class="text-warning text-center mb-2">
                                You are logged in, <br>but you don't have enough balance to pay. <br>
                                <small>Please top up your account first.</small>
                            </div>
                        @else
                            <div class="text-muted small mb-2">
                                As you are logged in, you can pay now.
                            </div>
                            <button class="btn btn-primary w-100" data-bs-toggle="modal"
                                    data-bs-target="#paymentConfirmModal">
                                Pay
                            </button>
                        @endif
                    @else
                        <button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#loginModal">
                            Sign in and Pay
                        </button>
                    @endauth
                    <div class="mt-3">
                        <form action="{{ route('payment.cancel', $paymentRequest->id) }}" id="cancelForm">
                            <button type="button" class="btn text-secondary border-0 w-100" data-bs-toggle="modal"
                                    data-bs-target="#cancelModal">
                                Cancel
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center small mt-2 text-muted">{{$gs->title}}</div>
    </div>

    @guest('web')
        <div class="modal fade" id="loginModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
             aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm modal-dialog-centered">
                <div class="modal-content">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body">
                        <div class="p-3">
                            @include('payment.fragments.login')
                        </div>
                        <div class="text-center small mt-2 text-muted">{{$gs->title}}</div>
                    </div>
                </div>
            </div>
        </div>
    @endguest

    @auth('web')
        <div class="modal fade" id="paymentConfirmModal" data-bs-backdrop="static" data-bs-keyboard="false"
             tabindex="-1"
             aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm modal-dialog-centered">
                <div class="modal-content">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body">
                        <div class="p-3">
                            @include('payment.fragments.process-payment')
                        </div>
                        <div class="text-center small mt-2 text-muted">{{$gs->title}}</div>
                    </div>
                </div>
            </div>
        </div>
    @endguest

    <div class="modal fade" id="cancelModal" data-bs-backdrop="static" data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div>
                        <div class="text-center py-4 mb-3" style="font-size: 1rem">
                            <div class="mb-3 text-info">
                                <svg xmlns="http://www.w3.org/2000/svg" width="70" height="70" fill="currentColor"
                                     class="bi bi-question-circle" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                    <path
                                        d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286m1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94"/>
                                </svg>
                            </div>
                            <div class="modal-title text-center">
                                Are you sure?
                            </div>
                            You want to cancel this payment!
                        </div>
                        <div class="d-flex gap-2 justify-content-center">
                            <button class="btn" type="button" data-bs-dismiss="modal">No, don't</button>
                            <button class="btn btn-danger" type="submit" form="cancelForm">Yes, Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{asset('assets/user/js/jquery-3.6.0.min.js')}}"></script>
<script src="{{asset('assets/user/js/tabler.min.js')}}"></script>
<x-htmx-alpine dont-push/>
</body>
</html>
