@extends('layouts.user')

@push('css')
@endpush

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{ __('Deposit Now') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card p-3 p-sm-4 p-lg-5">
                        @includeIf('includes.flash')
                        <form id="deposit-form" action="" method="POST" enctype="multipart/form-data">
                            @csrf
                            {{-- <div class="form-group">
                                <label class="form-label required">{{ __('Payment Method') }}</label>
                                <select name="method" id="withmethod" class="form-select" required>
                                    <option value="">{{ __('Select Payment Method') }}</option>
                                    @foreach ($gateways as $gateway)
                                        @if ($gateway->type == 'manual')
                                            <option value="Manual" data-details="{{ $gateway->details }}"
                                                data-title="{{ $gateway->title }}" data-id="{{ $gateway->id }}"
                                                data-charge="{{ $gateway->deposit_charge }}" data-fix-charge="{{ $gateway->deposit_charge_fix }}">
                                                {{ $gateway->title }}</option>
                                        @endif
                                        @if (in_array($gateway->keyword, $availableGatways))
                                            <option value="{{ $gateway->keyword }}" data-id="{{ $gateway->id }}"
                                                data-charge="{{ $gateway->deposit_charge }}" data-fix-charge="{{$gateway->deposit_charge_fix}}">{{ $gateway->name }}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div> --}}



                            <div class="form-group">
                                <p id="bkashNote" class="text-danger fw-bold mt-2 text-center" style="display: none;">
                                    {{ __('Please change your currency to BDT at the header before using Bkash.') }}
                                </p>
                                <label class="form-label required">{{ __('Payment Method') }}</label>
                                <select name="method" id="withmethod" class="form-select" required>
                                    <option value="">{{ __('Select Payment Method') }}</option>
                                    @foreach ($gateways as $gateway)
                                        @if ($gateway->type == 'manual')
                                            <option value="Manual" data-details="{{ $gateway->details }}"
                                                data-title="{{ $gateway->title }}" data-id="{{ $gateway->id }}"
                                                data-charge="{{ $gateway->deposit_charge }}" data-fix-charge="{{ $gateway->deposit_charge_fix }}">
                                                {{ $gateway->title }}
                                            </option>
                                        @endif
                                        @if (in_array($gateway->keyword, $availableGatways))
                                            <option value="{{ $gateway->keyword }}" data-id="{{ $gateway->id }}"
                                                data-charge="{{ $gateway->deposit_charge }}" data-fix-charge="{{ $gateway->deposit_charge_fix }}">
                                                {{ $gateway->name }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                            <input type="hidden" name="gateway_id" id="gateway_id" value="" />


                            <div id="card-view" class="col-lg-12 pt-3 d-none">
                                <div class="row">
                                    <input type="hidden" name="cmd" value="_xclick">
                                    <input type="hidden" name="no_note" value="1">
                                    <input type="hidden" name="lc" value="UK">
                                    <input type="hidden" name="bn"
                                        value="PP-BuyNowBF:btn_buynow_LG.gif:NonHostedGuest">

                                    <div class="col-lg-6 mb-3">
                                        <input type="text" class="form-control card-elements" name="cardNumber"
                                            placeholder="{{ __('Card Number') }}" autocomplete="off" required autofocus
                                            oninput="validateCard(this.value);" />
                                        <span id="errCard"></span>
                                    </div>

                                    <div class="col-lg-6 cardRow mb-3">
                                        <input type="text" class="form-control card-elements"
                                            placeholder="{{ 'Card CVC' }}" name="cardCVC"
                                            oninput="validateCVC(this.value);">
                                        <span id="errCVC"></span>
                                    </div>

                                    <div class="col-lg-6">
                                        <input type="text" class="form-control card-elements"
                                            placeholder="{{ __('Month') }}" name="month">
                                    </div>

                                    <div class="col-lg-6">
                                        <input type="text" class="form-control card-elements"
                                            placeholder="{{ __('Year') }}" name="year">
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-12 mt-4 manual-payment d-none">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">

                                            <div class="col-lg-12 pb-2 manual-payment-details">
                                            </div>

                                            <div class="col-lg-12">
                                                <label class="form-label required">@lang('Transaction ID')#</label>
                                                <input class="form-control" name="txn_id4" type="text"
                                                    placeholder="Transaction ID#" id="manual_transaction_id">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <input type="hidden" name="currency_sign" value="{{ $defaultCurrency->sign }}">
                            <input type="hidden" id="currencyCode" name="currency_code"
                                value="{{ $defaultCurrency->name }}">
                                <input type="hidden" id="fixcharge" value="">
                            <input type="hidden" name="currency_id" value="{{ $defaultCurrency->id }}">
                            <div class="form-group mb-3 mt-3">
                                <label class="form-label required">{{ __('Deposit Amount') }}</label>
                                <input name="amount" id="amount" class="form-control" autocomplete="off"
                                    placeholder="{{ __('0.0') }}" type="number" value="{{ old('amount') }}"
                                    min="1" required>
                            </div>

                            <div class="form-group mb-3 mt-3">
                                <label class="form-label required">{{ __('Charge') }} </label>
                                <input id="charge" name="charge" class="form-control" readonly autocomplete="off"
                                    placeholder="{{ __('0.0') }}" type="number" value="{{ old('charge') }}"
                                    min="1" required>

                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">{{ __('Description') }}</label>
                                <textarea name="details" class="form-control nic-edit" cols="30" rows="5"
                                    placeholder="{{ __('Receive account details') }}"></textarea>
                            </div>

                            <div class="manual-payment d-none">
                                @foreach ($gateways as $gateway)
                                    @if ($gateway->type == 'manual' && !empty($gateway->additional_fields))
                                        <div class="manual-payment__additional-fields d-none"
                                            data-title="{{ $gateway->title }}">
                                            @foreach ($gateway->additional_fields as $field)
                                                <div class="form-group">
                                                    <label
                                                        class="form-label @if ($field['validation'] == 'required') required @endif">{{ $field['field_name'] }}</label>
                                                    @if ($field['type'] != 'textarea')
                                                        <input type="{{ strtolower($field['type']) }}"
                                                            name="additional[{{ $field['field_name'] }}]"
                                                            class="form-control" placeholder="{{ $field['field_name'] }}"
                                                            @if (strtolower($field['type']) == 'file') accept="image/png,image/jpeg,image/gif,application/pdf" @endif
                                                            @required($field['validation'] == 'required') />
                                                    @else
                                                        <textarea name="additional[{{ $field['field_name'] }}]" class="form-control"
                                                            placeholder="{{ $field['field_name'] }}" @required($field['validation'] == 'required')></textarea>
                                                    @endif
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                            <div class="form-footer">
                                <button type="submit" id="submitBtn" class="btn btn-primary w-100">
                                    {{ __('Submit') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script type="text/javascript">
        'use strict';

        $(document).on('change', '#withmethod', function() {
            var val = $(this).val();

            $('#gateway_id').val($(this).find(':selected').data('id'));

            if (val === 'stripe') {
                $('#deposit-form').prop('action', '{{ route('deposit.stripe.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'flutterwave') {
                $('#deposit-form').prop('action', '{{ route('deposit.flutter.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'authorize.net') {
                $('#deposit-form').prop('action', '{{ route('deposit.authorize.submit') }}');
                $('#card-view').removeClass('d-none');
                $('.card-elements').prop('required', true);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'paypal') {
                $('#deposit-form').prop('action', '{{ route('deposit.paypal.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'mollie') {
                $('#deposit-form').prop('action', '{{ route('deposit.molly.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }


            if (val === 'paytm') {
                $('#deposit-form').prop('action', '{{ route('deposit.paytm.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);

                $('.manual-payment').addClass('d-none');
            }

            if (val === 'instamojo') {
                $('#deposit-form').prop('action', '{{ route('deposit.instamojo.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'razorpay') {
                $('#deposit-form').prop('action', '{{ route('deposit.razorpay.submit') }}');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', false);
                $('.manual-payment').addClass('d-none');
            }

            if (val === 'Manual') {
                $('#deposit-form').prop('action', '{{ route('deposit.manual.submit') }}');
                $('.manual-payment').removeClass('d-none');
                $('#card-view').addClass('d-none');
                $('.card-elements').prop('required', false);
                $('#manual_transaction_id').prop('required', true);
                const details = $(this).find(':selected').data('details');
                const title = $(this).find(':selected').data('title');
                $('.manual-payment-details').empty().append(`<font size="3">${details}</font>`)
                $('.manual-payment__additional-fields').addClass('d-none');
                $(`.manual-payment__additional-fields[data-title="${title}"]`).removeClass('d-none');
                $('.manual-payment__additional-fields').each(function() {
                    if ($(this).hasClass('d-none')) {
                        $(this).find('input, textarea').each(function() {
                            if ($(this)[0].hasAttribute('required')) {
                                $(this)[0].hasRequiredAttribute = true;
                            }
                            if ($(this)[0].hasRequiredAttribute) {
                                $(this).prop('required', false);
                            }
                        });
                    } else {
                        $(this).find('input, textarea').each(function() {
                            if ($(this)[0].hasAttribute('required')) {
                                $(this)[0].hasRequiredAttribute = true;
                            }
                            if ($(this)[0].hasRequiredAttribute) {
                                $(this).prop('required', true);
                            }
                        });
                    }
                });
            }

        });

        $('.manual-payment__additional-fields').each(function() {
            $(this).find('input, textarea').each(function() {
                if ($(this)[0].hasAttribute('required')) {
                    $(this)[0].hasRequiredAttribute = true;
                }
                if ($(this)[0].hasRequiredAttribute) {
                    $(this).prop('required', false);
                }
            });
        });
    </script>

    <script>
        'use strict';
        let currentChargeRate = 0;
        let currentChargefix = 0;

        document.getElementById('withmethod').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const chargeAttr = selectedOption.getAttribute('data-charge');
            const chargeAttrfix = selectedOption.getAttribute('data-fix-charge');

            currentChargeRate = parseFloat(chargeAttr) || 0; // Update charge rate
            currentChargefix = parseFloat(chargeAttrfix) || 0; // Update charge rate
            console.log('Selected charge rate:', currentChargeRate);
            console.log('Selected fix charge rate:', currentChargefix);
            $('#amount').trigger('input');
        });


        $(document).on('input', '#amount', function() {
            const amount = parseFloat($(this).val());
            if (!isNaN(amount) && amount > 0) {
                const charge = (amount * currentChargeRate) / 100;
               let mixcharge = charge + currentChargefix
                $('#charge').val(mixcharge.toFixed(2));

            } else {
                $('#charge').val('');
            }
        });
    </script>
    <script>
        document.getElementById('withmethod').addEventListener('change', function () {
            let selected = this.value.toLowerCase();
            let submitBtn = document.getElementById('submitBtn');
            let bkashNote = document.getElementById('bkashNote');
            
            if (selected === 'manual') {
                @if (globalCurrency()->name !== "BDT")
                    submitBtn.style.display = 'none';
                    bkashNote.style.display = 'block';
                @else
                    submitBtn.style.display = 'block';
                    bkashNote.style.display = 'none';
                @endif
            } else {
                submitBtn.style.display = 'block';
                bkashNote.style.display = 'none';
            }
        });
    </script>
@endpush
