@extends('layouts.user')

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{__('Statement')}}
                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">

                        <a href="javascript:history.go(-1)" class="btn btn-primary d-none d-sm-inline-block">
                            {{__('Back')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">


                        <div class="card-body">
                            <h3 class="card-title">@lang('Statement data range')</h3>

                            <form>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="from" class="form-label">From</label>
                                            <input type="date" class="form-control datefield" name="from" id="from"
                                                   value="{{ request('from') }}" required/>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="to" class="form-label">To</label>
                                            <input type="date" class="form-control datefield" name="to" id="to"
                                                   value="{{ request('to') }}" required/>
                                        </div>

                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-search"></i>
                                            <span class="ms-2">@lang('Search')</span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>


                        @if(count($transactions) > 0)
                            <div class="px-3 mb-3 mt-3 text-end">
                                <a class="btn btn-primary" target="_blank"
                                   href="{{ route('user.export-statement.pdf', request()->only(['from', 'to'])) }}">
                                    Download PDF</a>
                                <a class="btn btn-primary" target="_blank"
                                   href="{{ route('user.export-statement.xlsx', request()->only(['from', 'to'])) }}">
                                    Download Excel</a>
                            </div>

                            <div class="table-responsive">
                                <table class="table card-table table-vcenter text-nowrap datatable">
                                    <thead>
                                    <tr>
                                        <th class="w-1">@lang('No').
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                 class="icon icon-sm text-dark icon-thick" width="24" height="24"
                                                 viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                                 stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <polyline points="6 15 12 9 18 15"/>
                                            </svg>
                                        </th>
                                        <th>@lang('Date')</th>
                                        <th>@lang('Type')</th>
                                        <th>@lang('Txnid')</th>
                                        <th class="text-end">@lang('Debit')</th>
                                        <th class="text-end">@lang('Credit')</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse ($transactions as $key=>$data)
                                        <tr>
                                            <td data-label="@lang('No')">
                                                <div>
                                                    <span class="text-muted">{{ $loop->iteration }}</span>
                                                </div>
                                            </td>

                                            <td data-label="@lang('Date')">
                                                <div>
                                                    {{date('d M Y',strtotime($data->created_at))}}
                                                </div>
                                            </td>

                                            <td data-label="@lang('Type')">
                                                <div>
                                                    {{ strtoupper($data->type) }}
                                                </div>
                                            </td>

                                            <td data-label="@lang('Txnid')">
                                                <div>
                                                    {{ $data->txnid }}
                                                </div>
                                            </td>


                                            <td data-label="@lang('Debit')" class="text-end">
                                                @if($data->profit !== 'plus')
                                                    <div>
                                                        <p class="m-0 text-{{ $data->profit == 'plus' ? 'success' : 'danger'}}">{{ showprice($data->amount,$currency) }}</p>
                                                    </div>
                                                @else
                                                    -
                                                @endif
                                            </td>

                                            <td data-label="@lang('Credit')" class="text-end">
                                                @if($data->profit == 'plus')
                                                    <div>
                                                        <p class="m-0 text-{{ $data->profit == 'plus' ? 'success' : 'danger'}}">{{ showprice($data->amount,$currency) }}</p>
                                                    </div>
                                                @else
                                                    -
                                                @endif
                                            </td>

                                            <td></td>

                                        </tr>
                                    @empty
                                        <p>@lang('NO DATA FOUND')</p>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            {{ $transactions->links() }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>
    <br>
    <br>

@endsection



@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
@endpush
@push('js')
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr(".datefield", {
            dateFormat: "Y-m-d",
            maxDate: "today",
        });

    </script>
@endpush
