@extends('layouts.user')

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{ __('Notifications') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table id="dataTable" class="table card-table table-vcenter text-nowrap datatable">
                                <thead>
                                    <tr>
                                        <th width="1%">{{ __("S/N") }}</th>
                                        <th>{{ __("Notification") }}</th>
                                        <th>{{ __("Created At") }}</th>
                                        <th class="text-right">{{ __("Options") }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="10" class="text-center py-4">No transaction found</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.2/css/dataTables.bootstrap5.css">
    <style>
        #dt-search-0.form-control-sm, .dt-length #dt-length-0.form-select-sm {
            height: auto;
            padding: .28rem .75rem; 
            font-size: 1rem;
        }
    </style>
@endpush
@push('js')
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.bootstrap5.js"></script>
    <script>
        $(function() {
            var table = $('#dataTable').DataTable({
                ordering: true,
                processing: true,
                serverSide: true,
                searching: true,
                ajax: {
                    "url": '{{ url()->current() }}',
                    "type": "GET",
                },
                columns: [
                    {data: 'DT_RowIndex',name: 'DT_RowIndex',orderable: false,searchable: false,className: 'text-center'},
                    {data: 'details_data',name: 'data'},
                    {data: 'date_data',name: 'created_at'},
                    {data: 'action', searchable: false, orderable: false, className: 'text-right'}
                ],
                order: [
                    [1, 'desc']
                ],
                lengthMenu: [15, 30, 50, 75, 100, 500, 1000],
            });
        })
    </script>
@endpush