@extends('layouts.user')

@section('contents')

    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{__('Payment API')}}
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body"
         x-data="{}"
         @text-copied="showToast($event.detail+' copied to clipboard')"
    >
        <div class="container-xl">
            <div class="row row-cards mb-3">
                <div class="col-md-6">
                    <div class="mb-4">
                        <div class="d-flex flex-column flex-sm-row">
                            <div>
                                <div class="form-group mb-3">
                                    <label class="form-label text-muted" for="merchant_id">Merchant Name</label>
                                    <p class="h3">{{ $user->name }}</p>
                                </div>
                                <div class="form-group mb-3">
                                    <label class="form-label text-muted" for="merchant_id">Merchant ID</label>
                                    <p class="h4">{{ $merchant->merchant_id }}</p>
                                </div>
                                <form
                                    x-data="{
                                        enabled: {{ $merchant->status==1 ? 'true' : 'false' }},
                                        afterResponse(event){
                                            const response = JSON.parse(event.detail.xhr.responseText);
                                            toastr.success(response.message);
                                            this.enabled = response.enabled;
                                        },
                                    }"
                                    id="enable_payment_form"
                                    x-ref="enable_payment_form"
                                >
                                    <div class="form-group mb-3">
                                        @csrf
                                        <div class="form-label text-muted">Enable/Disable Payment</div>
                                        <label
                                            class="form-check form-switch form-switch-lg d-inline-flex align-items-center gap-2">
                                            <input
                                                type="checkbox"
                                                class="form-check-input"
                                                @checked($merchant->status==1)
                                                hx-trigger="change"
                                                hx-post="?action=enable-payment"
                                                hx-target=""
                                                hx-swap="none"
                                                @htmx:after-request="afterResponse"
                                                @htmx:response-error="toastr.error('Failed to change payment status')"
                                            />
                                            <span class="form-check-label" x-text="enabled ? 'Enabled' : 'Disabled'">
                                                {{ $merchant->status==1 ? 'Enabled' : 'Disabled' }}
                                            </span>
                                        </label>
                                    </div>
                                </form>
                            </div>

                            <div class="ms-sm-auto me-4">
                                <form action="?action=upload-logo"
                                      id="upload_logo_form"
                                      hx-post="?action=upload-logo"
                                      hx-target="this"
                                      hx-swap="innerHTML"
                                      enctype="multipart/form-data"
                                      @htmx:after-swap="toastr.success('Merchant logo updated successfully')"
                                      @htmx:response-error="toastr.error('Failed to upload logo')"
                                >
                                    @include('includes.user.fragments.upload_logo_form')
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group mb-3">
                        <div class="d-flex">
                            <label class="form-label" for="merchant_id">Merchant ID</label>
                        </div>
                        <div class="position-relative">
                            <input type="text" class="form-control form--control text-truncate" id="merchant_id"
                                   value="{{ $merchant->merchant_id }}"
                                   style="padding-right: 50px"
                                   readonly/>
                            <button class="position-absolute btn px-2" type="button"
                                    @click="$clipboard('{{ $merchant->merchant_id }}');$dispatch('text-copied', 'Merchant ID')"
                                    style="top: 50%; right: 7px; transform: translateY(-50%)">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                     stroke-linejoin="round" class="text-muted">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <path
                                        d="M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z"/>
                                    <path
                                        d="M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1"/>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <div class="form-group mb-3">
                        <div class="d-flex">
                            <label class="form-label" for="public_key">Public Key</label>
                        </div>
                        <div class="position-relative">
                            <input type="text" class="form-control form--control text-truncate" id="public_key"
                                   value="{{ $merchant->public_key }}"
                                   style="padding-right: 50px"
                                   readonly>
                            <button class="position-absolute btn px-2" type="button"
                                    @click="$clipboard('{{ $merchant->public_key }}');$dispatch('text-copied', 'Public Key')"
                                    style="top: 50%; right: 7px; transform: translateY(-50%)">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                     stroke-linejoin="round" class="text-muted">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <path
                                        d="M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z"/>
                                    <path
                                        d="M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="form-group mb-3">
                        <div class="d-flex">
                            <label class="form-label" for="secret_key">Secret Key</label>
                        </div>
                        <div class="position-relative">
                            <input type="password" class="form-control form--control text-truncate" id="secret_key"
                                   value="{{ $merchant->secret_key }}"
                                   style="padding-right: 50px"
                                   readonly
                                   @focus="$el.type='text'"
                                   @click.outside="$el.type='password'"
                            >
                            <button class="position-absolute btn px-2" type="button"
                                    @click="$clipboard('{{ $merchant->secret_key }}');$dispatch('text-copied', 'Secret Key')"
                                    style="top: 50%; right: 7px; transform: translateY(-50%)">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                     stroke-linejoin="round" class="text-muted">
                                    <path
                                        stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <path
                                        d="M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z"/>
                                    <path
                                        d="M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <x-payment-api.how-api-works :$merchant/>
        </div>
    </div>

    <x-htmx-alpine/>
@endsection

@push('css')
    <link href="https://unpkg.com/prismjs@v1.x/themes/prism.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" rel="stylesheet" type="text/css"/>
@endpush
@push('js')
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script src="https://unpkg.com/prismjs@v1.x/components/prism-core.min.js"></script>
    <script src="https://unpkg.com/prismjs@v1.x/plugins/autoloader/prism-autoloader.min.js"></script>
    <script>
        function showToast(message) {
            Toastify({
                text: message,
                duration: 1500,
                newWindow: true,
                close: false,
                gravity: "bottom",
                position: "center",
                stopOnFocus: false,
                style: {
                    background: "#000",
                },
            }).showToast();
        }
    </script>
@endpush
