<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Payment Test</title>

    <link href="{{asset('assets/user/css/tabler.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('assets/user/css/tabler-vendors.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="{{asset('assets/front/css/toastr.min.css')}}">
    <link href="{{asset('assets/user/css/custom.css')}}?v=1.1" rel="stylesheet"/>

</head>
<body>

<div class="container mt-5">

    <div class="row justify-content-center">
        <div class="col-md-6">
            <form action="{{ route('payment.request') }}" method="POST">
                <input class="form-control mb-1" type="text" name="merchant_id" value="{{ $merchant->merchant_id }}"
                       placeholder="merchant_id"/>
                <div class="d-flex gap-1">
                    <input class="form-control mb-1" type="number" name="amount" value="1" placeholder="amount"/>
                    <input class="form-control mb-1" type="text" name="currency" value="USD" placeholder="currency"/>
                </div>
                <input class="form-control mb-1" type="text" name="customer[name]" value="Customer Name"
                       placeholder="customer[name]"/>
                <input class="form-control mb-1" type="text" name="customer[email]" value="customer@gmail.com"
                       placeholder="customer[email]"/>
                <input class="form-control mb-1" type="text" name="customer[phone]" value="8801710123456"
                       placeholder="customer[phone]"/>
                <input class="form-control mb-1" type="text" name="description" value="" placeholder="description"/>
                <input class="form-control mb-1" type="text" name="metadata[order_id]" value=""
                       placeholder="metadata[order_id]"/>
                <input class="form-control mb-1" type="text" name="return_url"
                       value="http://localhost:8000/payment/success"
                       placeholder="return_url"/>
                <input class="form-control mb-1" type="text" name="cancel_url"
                       value="http://localhost:8000/payment/cancel"
                       placeholder="cancel_url"/>
                <input class="form-control mb-1" type="text" name="webhook_url" value="http://localhost:8000/webhook"
                       placeholder="webhook_url"/>
                <input class="form-control mb-1" type="text" name="token"
                       value="{{ $merchant->public_key }}" placeholder="token"/>
                <button class="btn btn-primary">Pay $1.00</button>
            </form>
        </div>
    </div>

</div>

<script src="{{asset('assets/front/js/jquery-3.6.0.min.js')}}"></script>
<script src="{{asset('assets/front/js/bootstrap.min.js')}}"></script>
</body>
</html>
