@extends('layouts.user')

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{ __('Payment QR') }}
                    </h2>
                </div>

            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-md-6">

                    <div class="card shadow-lg border-0 rounded-3 text-center p-4">
                        <div class="card-body">
                            <h1 class="fw-bold mb-3">{{ $gs->title }}</h1>
                            <h4 class="fw-semibold mb-4">Scan the QR code to make a payment</h4>
                            {{-- QR Code --}}
                            <img id="qrImage" src="{{ $qrImage }}" class="d-block mx-auto mb-4" style="width: 250px;" alt="QR Code">

                            {{-- Download Button --}}
                            <a href="{{ route('user.download-qr') }}" download="qr_code.png" class="btn btn-primary mb-4">
                                Download QR Code
                            </a>

                            {{-- Account Info --}}
                            <h2 class="fw-bold fs-1 mb-3">{{ auth()->user()->name }} {{ auth()->user()->last_name }}</h2>
                            <h3 class="fw-bold fs-2 mb-2">Account Number: {{ auth()->user()->account_number }}</h3>
                            <h4 class="fw-semibold fs-3 text-muted">Account Type: {{ ucfirst(auth()->user()->account_type) }}</h4>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



@endsection


@push('css')
    
@endpush
