

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Running DPS')); ?></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dps.index')); ?>"><?php echo e(__('DPS')); ?></a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">

            <?php echo $__env->make('includes.admin.form-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th><?php echo e(__('Plan No')); ?></th>
                            <th><?php echo e(__('Deposit Amount')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Total Installment')); ?></th>
                            <th><?php echo e(__('Matured Amount')); ?></th>
                            <th><?php echo e(__('Next Installment')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: false,
            ajax: '<?php echo e(route('admin.dps.datatables',['status' => 1])); ?>',
            columns: [
                {data: 'transaction_no', name: 'transaction_no'},
                {data: 'deposit_amount', name: 'deposit_amount'},
                {data: 'user_id', name: 'user_id'},
                {data: 'total_installment', name: 'total_installment'},
                {data: 'matured_amount', name: 'matured_amount'},
                {data: 'next_installment', name: 'next_installment'},
                {data: 'status', orderable: false},
                {data: 'action', searchable: false, orderable: false}
            ],
            language: {
                processing: '<img src="<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>">'
            }
        });

    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/dps/running.blade.php ENDPATH**/ ?>