

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('DPS')); ?></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dps.index')); ?>"><?php echo e(__('DPS')); ?></a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">

            <?php echo $__env->make('includes.admin.form-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th><?php echo e(__('Plan No')); ?></th>
                            <th><?php echo e(__('Deposit Amount')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Total Installment')); ?></th>
                            <th><?php echo e(__('Matured Amount')); ?></th>
                            <th><?php echo e(__('Next Installment')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th> <?php echo e(__('Last Status')); ?> </th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    

    <div class="modal fade confirm-modal" id="dpsCloseModal" tabindex="-1" role="dialog"
         aria-labelledby="dpsCloseModalTitle" aria-hidden="true">void(0)
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__("Close DPS")); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center"><?php echo e(__("You are about to close the DPS.")); ?></p>
                    <p class="text-center"><?php echo e(__("Do you want to proceed?")); ?></p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("Cancel")); ?></a>
                    <a href="javascript:void(0);" class="btn btn-success btn-ok"><?php echo e(__("Close")); ?></a>
                </div>
            </div>
        </div>
    </div>

    


    

    <div class="modal fade confirm-modal" id="dpsAddAmountModal" tabindex="-1" role="dialog"
        aria-labelledby="dpsAddAmountModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__("Add Amount to Pending DPS")); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center"><?php echo e(__("This DPS has a pending installment due to insufficient balance.")); ?></p>
                    <p class="text-center"><?php echo e(__("Do you want to deposit the required amount to continue the DPS?")); ?></p>
                    <p class="text-center font-weight-bold">
                        <?php echo e(__("Amount to deposit:")); ?> <span id="pendingAmount"></span>
                    </p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("Cancel")); ?></a>
                    <a href="javascript:void(0);" class="btn btn-success btn-ok"><?php echo e(__("Add Amount")); ?></a>
                </div>
            </div>
        </div>
    </div>


    

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '<?php echo e(route('admin.dps.datatables',['status' => 'all'])); ?>',
            columns: [
                {data: 'transaction_no', name: 'transaction_no'},
                {data: 'deposit_amount', name: 'deposit_amount'},
                {data: 'user_id', name: 'user_id'},
                {data: 'total_installment', name: 'total_installment'},
                {data: 'matured_amount', name: 'matured_amount'},
                {data: 'next_installment', name: 'next_installment'},
                {data: 'status', searchable: false},
                {data: 'status_last_history', name: 'lastHistory.admin.name'},
                {data: 'action', searchable: false, orderable: false}
            ],
            language: {
                processing: '<img src="<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>">'
            }
        });


        // When modal opens
        $('#dpsAddAmountModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var url = button.data('href');
            var amount = button.data('amount');

            var modal = $(this);

            modal.find('.btn-ok').attr('href', url);
            modal.find('#pendingAmount').text(amount);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/dps/index.blade.php ENDPATH**/ ?>