

<?php $__env->startSection('content'); ?>
    <div class="card mb-4">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('User List')); ?></h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>

                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.user.logs')); ?>"><?php echo e(__('User Login Logs')); ?></a></li>
            </ol>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            
            <div class="table-responsive">
                <table id="geniustable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th><?php echo e(__('ID')); ?></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Phone')); ?></th>
                            <th><?php echo e(__('IP Address')); ?></th>
                            <th><?php echo e(__('Device')); ?></th>
                            <th><?php echo e(__('Browser')); ?></th>
                            <th><?php echo e(__('Location')); ?></th>
                            <th><?php echo e(__('Coordinates')); ?></th>
                            <th><?php echo e(__('Date')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    <?php if($multipulUsersameIp->count()): ?>
    <div class="card mt-5">
        <div class="card-header">
           <h4> <?php echo e(__(' Same Ip Multipul User List')); ?></h4>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th><?php echo e(__('IP Address')); ?></th>
                        <th><?php echo e(__('Users Sharing IP')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $multipulUsersameIp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($ip->ip); ?></td>
                            <td>
                                <?php
                                    $users = \App\Models\LoginLogs::with('user')
                                        ->where('ip', $ip->ip)
                                        ->get()
                                        ->pluck('user.name')
                                        ->unique();
                                ?>
                                <?php echo e($users->join(', ')); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(function() {
            $('#geniustable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('admin.user.logs.search')); ?>',
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'name',
                        name: 'user.name'
                    },
                    {
                        data: 'email',
                        name: 'user.email'
                    },
                    {
                        data: 'phone',
                        name: 'user.phone'
                    },
                    {
                        data: 'ip',
                        name: 'ip'
                    },
                    {
                        data: 'device',
                        name: 'device'
                    },
                    {
                        data: 'browser',
                        name: 'browser'
                    },
                    {
                        data: 'location',
                        name: 'city'
                    },
                    {
                        data: 'coordinates',
                        name: 'latitude'
                    },
                    {
                        data: 'date',
                        name: 'created_at'
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/user/LogInfo.blade.php ENDPATH**/ ?>