<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center py-3 justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Missed Installments')); ?> <a class="btn btn-primary btn-rounded btn-sm"
                                                                             href="<?php echo e(route('admin.loan.index')); ?>"><i
                        class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.loan.index')); ?>"><?php echo e(__('Loans')); ?></a></li>
                <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Missed Installments')); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-lg-12">
            <?php echo $__env->make('includes.admin.form-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                <?php echo e(__('Loan Information')); ?>

                            </h4>
                        </div>
                        <div class="table-responsive-sm">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th width="45%"><?php echo e(__('Transaction No')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->transaction_no); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Plan Name')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->plan->title); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('User')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%">
                                        <?php echo e($loan->user->name); ?> <?php echo e($loan->user->last_name); ?>

                                        <?php if($loan->user->is_suspended): ?>
                                            <span class="badge badge-danger">Suspended</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('User Email')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->user->email); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('User Balance')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($currency->sign); ?> <?php echo e(number_format($loan->user->balance, 2)); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Loan Amount')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($currency->sign); ?> <?php echo e(number_format($loan->loan_amount, 2)); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Total Installments')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->total_installment); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Given Installments')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->given_installment); ?></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Missed Installments')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="badge badge-danger"><?php echo e($loan->missed_installment_count); ?></span></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Remaining Installments')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><?php echo e($loan->total_installment - $loan->given_installment); ?></td>
                                </tr>
                                <?php if($loan->user->is_suspended): ?>
                                <tr>
                                    <th width="45%"><?php echo e(__('Suspend Reason')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="text-danger"><?php echo e($loan->user->suspend_reason); ?></span></td>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                <?php echo e(__('Unpaid Missed Installments Summary')); ?>

                            </h4>
                        </div>
                        <div class="table-responsive-sm">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th width="45%"><?php echo e(__('Total Unpaid Missed')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="badge badge-danger"><?php echo e($unpaidMissed->count()); ?></span></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('Total Amount Due')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%"><strong class="text-danger"><?php echo e($currency->sign); ?> <?php echo e(number_format($totalUnpaidAmount, 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <th width="45%"><?php echo e(__('User Available Balance')); ?></th>
                                    <th width="10%">:</th>
                                    <td width="45%">
                                        <?php echo e($currency->sign); ?> <?php echo e(number_format($loan->user->balance, 2)); ?>

                                        <?php if($loan->user->balance >= $totalUnpaidAmount): ?>
                                            <span class="badge badge-success">Sufficient</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">Insufficient</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <?php if($unpaidMissed->count() > 0): ?>
                        <div class="footer-area mt-3">
                            <?php if($loan->user->balance >= $totalUnpaidAmount): ?>
                                <button type="button" class="btn btn-success" onclick="payMissedInstallments()">
                                    <i class="fas fa-check-circle"></i> <?php echo e(__('Process Payment & Unsuspend User')); ?>

                                </button>
                            <?php else: ?>
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i> 
                                    <?php echo e(__('User does not have sufficient balance to pay missed installments.')); ?>

                                    <br>
                                    <?php echo e(__('Required')); ?> : <?php echo e($currency->sign); ?> <?php echo e(number_format($totalUnpaidAmount, 2)); ?>

                                    <br>
                                    <?php echo e(__('Available')); ?> : <?php echo e($currency->sign); ?> <?php echo e(number_format($loan->user->balance, 2)); ?>

                                    <br>
                                    <?php echo e(__('Shortage')); ?> : <?php echo e($currency->sign); ?> <?php echo e(number_format($totalUnpaidAmount - $loan->user->balance, 2)); ?>

                                </div>
                            <?php endif; ?>

                            <?php if($loan->user->is_suspended): ?>
                            <div class="mt-3">
                                <h6><?php echo e(__('Custom Amount Payment & Unblock')); ?></h6>
                                <div class="form-group">
                                    <label for="custom_amount"><?php echo e(__('Amount to Deduct')); ?> (<?php echo e($currency->sign); ?>)</label>
                                    <input type="number" 
                                           class="form-control" 
                                           id="custom_amount" 
                                           placeholder="Enter amount" 
                                           step="0.01" 
                                           min="0"
                                           max="<?php echo e($loan->user->balance); ?>"
                                           value="<?php echo e(min($totalUnpaidAmount, $loan->user->balance)); ?>">
                                    <small class="form-text text-muted">
                                        <?php echo e(__('Maximum available')); ?>: <?php echo e($currency->sign); ?> <?php echo e(number_format($loan->user->balance, 2)); ?>

                                    </small>
                                </div>
                                <button type="button" class="btn btn-primary" onclick="unblockWithCustomAmount()">
                                    <i class="fas fa-unlock-alt"></i> <?php echo e(__('Deduct Amount & Unblock User')); ?>

                                </button>
                                <button type="button" class="btn btn-warning ml-2" onclick="unsuspendUser()">
                                    <i class="fas fa-unlock"></i> <?php echo e(__('Unblock Without Payment')); ?>

                                </button>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if($loan->missedInstallments->count() > 0): ?>
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                <?php echo e(__('Missed Installments Details')); ?>

                            </h4>
                        </div>
                        <div class="table-responsive show-table">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('SL')); ?></th>
                                        <th><?php echo e(__('Installment No')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Due Date')); ?></th>
                                        <th><?php echo e(__('Missed Date')); ?></th>
                                        <th><?php echo e(__('Days Overdue')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Paid Date')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $loan->missedInstallments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $missed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="<?php echo e($missed->is_paid ? '' : 'table-danger'); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($missed->installment_number); ?></td>
                                            <td><?php echo e($currency->sign); ?> <?php echo e(number_format($missed->amount, 2)); ?></td>
                                            <td><?php echo e($missed->due_date->format('Y-m-d')); ?></td>
                                            <td><?php echo e($missed->missed_date->format('Y-m-d H:i')); ?></td>
                                            <td>
                                                <?php if($missed->is_paid): ?>
                                                    <?php echo e($missed->due_date->diffInDays($missed->paid_date)); ?> days
                                                <?php else: ?>
                                                    <?php echo e($missed->due_date->diffInDays(now())); ?> days
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($missed->is_paid): ?>
                                                    <span class="badge badge-success">Paid</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger">Unpaid</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($missed->is_paid): ?>
                                                    <?php echo e($missed->paid_date->format('Y-m-d H:i')); ?>

                                                <?php else: ?>
                                                    --
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="2"><?php echo e(__('Total Unpaid')); ?></th>
                                        <th colspan="6"><?php echo e($currency->sign); ?> <?php echo e(number_format($totalUnpaidAmount, 2)); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function payMissedInstallments() {
        if (!confirm('Are you sure you want to process payment for all missed installments? This will deduct <?php echo e($currency->sign); ?><?php echo e(number_format($totalUnpaidAmount, 2)); ?> from user balance and unsuspend the user.')) {
            return;
        }

        $.ajax({
            url: '<?php echo e(route("admin.loan.pay.missed.installments", $loan->id)); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('An error occurred while processing payment.');
            }
        });
    }

    function unsuspendUser() {
        if (!confirm('Are you sure you want to unsuspend this user without payment? The missed installments will remain unpaid.')) {
            return;
        }

        $.ajax({
            url: '<?php echo e(route("admin.loan.unsuspend.user", $loan->id)); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('An error occurred while unsuspending user.');
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/loan/missed_installments.blade.php ENDPATH**/ ?>