

<?php $__env->startSection('contents'); ?>
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('Transaction')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="<?php echo e(route('user.export-bank.solvency')); ?>"
                            class="btn btn-primary d-sm-inline-block">
                            Download Bank Solvency
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-wrap justify-content-between">
                            <div class="d-block d-md-inline-flex gap-2">
                                <div class="input-group">
                                    <span class="input-group-text">From</span>
                                    <input type="date" class="form-control" name="from" id="from_date"
                                        placeholder="From Date" />
                                </div>
                                <div class="input-group">
                                    <span class="input-group-text">To</span>
                                    <input type="date" class="form-control" name="to" id="to_date"
                                        placeholder="To Date" />
                                </div>
                                <button class="btn btn-primary d-sm-inline-block" id="applyBtn">
                                    Apply
                                </button>
                            </div>


                            <div id="exportArea" style="display: none;">
                                <div class=" d-md-flex gap-2" id="exportButtons">
                                    <div class="input-group">
                                        <a href="<?php echo e(route('user.export-statement.xlsx')); ?>"
                                            class="btn btn-primary d-sm-inline-block" id="excelDownload">
                                            Excel Download
                                        </a>
                                    </div>
                                    <a target="_blank" href="<?php echo e(route('user.export-statement.pdf')); ?>"
                                        class="btn btn-primary d-sm-inline-block" id="pdfDownload">
                                        Pdf Download
                                    </a>
                                </div>
                            </div>

                        </div>
                        <div class="table-responsive">
                            <table id="dataTable" class="table card-table table-vcenter text-nowrap datatable">
                                <thead>
                                    <tr class="dt-column-filter">
                                        <th class="w-1"></th>
                                        <th>
                                            <input type="text" class="form-control" placeholder="Search Date" />
                                        </th>
                                        <th>
                                            <select type="text" class="form-control  mb-0">
                                                <option value="">All</option>
                                                <option value="Send Money">Send Money</option>
                                                <option value="Wire Transfer">Wire Transfer</option>
                                                <option value="Referral Bonus">Referral Bonus</option>
                                                <option value="Deposit">Deposit</option>
                                                <option value="Withdraw">Withdraw</option>
                                                <option value="Request">Request</option>
                                            </select>
                                        </th>
                                        <th>
                                            <input type="text" class="form-control" placeholder="Search TxnID" />
                                        </th>
                                        <th><input type="text" class="form-control" placeholder="Search Sender" /></th>
                                        <th><input type="text" class="form-control" placeholder="Search Receiver" /></th>
                                        <th class="text-start">
                                            
                                        </th>
                                        <th class="text-start ">
                                            
                                        </th>
                                        <th class="text-start">
                                            
                                        </th>
                                        <th></th>
                                    </tr>
                                    <tr>
                                        <th class="w-1 text-center"><?php echo app('translator')->get('No'); ?>.</th>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                        <th><?php echo app('translator')->get('Type'); ?></th>
                                        <th><?php echo app('translator')->get('Txnid'); ?></th>
                                        <th><?php echo app('translator')->get('Sender'); ?></th>
                                        <th><?php echo app('translator')->get('Receiver'); ?></th>
                                        <th class="text-end"><?php echo app('translator')->get('Debit'); ?></th>
                                        <th class="text-end"><?php echo app('translator')->get('Credit'); ?></th>
                                        <th><?php echo app('translator')->get('Charge'); ?></th>
                                        
                                        <th class="text-end"><?php echo app('translator')->get('Available Balance'); ?></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="10" class="text-center py-4">No transaction found</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.2/css/dataTables.bootstrap5.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <style>
    #dt-search-0.form-control-sm, .dt-length #dt-length-0.form-select-sm {
    height: auto;
    padding: .28rem .75rem; 
    font-size: 1rem;
    }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.bootstrap5.js"></script>
    <script>
        $(function() {
            flatpickr("#from_date", {
                maxDate: 'today'
            });
            flatpickr("#to_date", {
                maxDate: 'today'
            });

            var table = $('#dataTable').DataTable({
                ordering: true,
                processing: true,
                serverSide: true,
                searching: true,
                ajax: {
                    "url": '<?php echo e(url()->current()); ?>',
                    "type": "GET",
                    "data": function(data) {
                        var from_date = $('#from_date').val();
                        var to_date = $('#to_date').val();
                        if (from_date && from_date !== '') {
                            data.from_date = from_date;
                        }
                        if (to_date && to_date !== '') {
                            data.to_date = to_date;
                        }
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false,
                        className: 'text-center'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'txnid',
                        name: 'txnid'
                    },
                    {
                        data: 'sender_account',
                        name: 'sender_account'
                    },
                    {
                        data: 'receiver_account',
                        name: 'receiver_account'
                    },
                    {
                        data: 'debit',
                        name: 'debit',
                        className: 'text-end'
                    },
                    {
                        data: 'credit',
                        name: 'credit',
                        className: 'text-end'
                    },
                    {
                        data: 'charge',
                        name: 'charge',
                        className: 'text-end'
                    },
                    {
                        data: 'available_balance',
                        name: 'available_balance',
                        className: 'text-end'
                    },
                    {
                        data: 'dummy',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [1, 'desc']
                ],
                lengthMenu: [15, 30, 50, 75, 100, 500, 1000],
                drawCallback: function() {
                    $('[data-toggle="tooltip"]').tooltip();
                    $('.dt-column-filter th').each(function() {
                        this.className = 'text-start p-1';
                        $(this).removeAttr('data-dt-column');
                        $(this).removeAttr('aria-sort');
                        $(this).find('.dt-column-order').remove();
                        if ($(this).find('.dt-column-title')[0]) {
                            $(this).find('.dt-column-title')[0].className = 'd-block';
                        }
                        if ($(this).find('.dt-column-header')[0]) {
                            $(this).find('.dt-column-header')[0].className = 'd-block';
                        }
                    })
                }
            });
            // Apply column filter
            $('#dataTable .dt-column-filter th').each(function(i) {
                $('input, select', this).on('keyup change', function() {
                    if (table.column(i).search() !== this.value) {
                        table.column(i).search(this.value).draw()
                    }
                });
            });

            //modified 
            $(document).on('click', '#applyBtn', function() {
                var from = $('#from_date').val() || 'null';
                var to = $('#to_date').val() || 'null';
                $('#exportArea').show();

                // Get base URLs from data attributes or original href
                let excelBaseUrl = $('#excelDownload').attr('href').split('?')[0];
                let pdfBaseUrl = $('#pdfDownload').attr('href').split('?')[0];

                $('#excelDownload').attr('href', `${excelBaseUrl}?from=${from}&to=${to}`);
                $('#pdfDownload').attr('href', `${pdfBaseUrl}?from=${from}&to=${to}`);

                table.draw();
            });





        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/user/transactions.blade.php ENDPATH**/ ?>