

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Add New Plan')); ?> <a class="btn btn-primary btn-rounded btn-sm"
                                                                             href="<?php echo e(route('admin.dps.plan.index')); ?>"><i
                        class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dps.plan.index')); ?>"><?php echo e(__('DPS Plan')); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Add New Plan Form')); ?></h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                         style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
                    <form class="geniusform" action="<?php echo e(route('admin.dps.plan.store')); ?>" method="POST"
                          enctype="multipart/form-data">

                        <?php echo $__env->make('includes.admin.form-both', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="form-group">
                            <label for="title"><?php echo e(__('Title')); ?></label>
                            <input type="text" class="form-control" id="title" name="title"
                                   placeholder="<?php echo e(__('Enter Title')); ?>" value="" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="installment_interval"><?php echo e(__('Installment Interval')); ?></label>
                                    <input type="number" class="form-control" id="installment_interval"
                                           name="installment_interval" placeholder="<?php echo e(__('Installment Interval')); ?>"
                                           min="1" value="" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_installment"><?php echo e(__('Total Installment')); ?></label>
                                    <input type="number" class="form-control" id="total_installment"
                                           name="total_installment" placeholder="<?php echo e(__('Total Installment')); ?>" min="1"
                                           value="" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="per_installment"><?php echo e(__('Per Installment')); ?></label>
                                    <input type="number" class="form-control" id="per_installment"
                                           name="per_installment" placeholder="<?php echo e(__('Per Installment')); ?>" min="1"
                                           value="" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interest_rate"><?php echo e(__('Interest Rate of Total Deposit')); ?> %</label>
                                    <input type="number" class="form-control" id="interest_rate" name="interest_rate"
                                           placeholder="<?php echo e(__('Interest Rate of Total Deposit')); ?>" min="1" value=""
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="final_amount"><?php echo e(__('Total Deposit')); ?> (<?php echo e($currency->name); ?>)</label>
                                    <input type="number" class="form-control" id="final_amount" name="final_amount"
                                           placeholder="<?php echo e(__('Total Deposit')); ?>" min="1" value="" required readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_profit"><?php echo e(__('User Profit')); ?> (<?php echo e($currency->name); ?>)</label>
                                    <input type="number" class="form-control" id="user_profit" name="user_profit"
                                           placeholder="<?php echo e(__('User Profit')); ?>" min="1" value="" required readonly>
                                </div>
                            </div>
                        </div>

                        <div>
                            <h3 class="col-lg-12 d-none deposit-amount text-primary text-center">
                                <?php echo e(__('After mature, the user will get')); ?> : (<?php echo e($currency->name); ?>) <span
                                    class="text-primary"></span>
                            </h3>
                        </div>


                        <button type="submit" id="submit-btn" class="btn btn-primary w-100"><?php echo e(__('Submit')); ?></button>

                    </form>
                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $('#per_installment, #total_installment, #interest_rate').on('input', (e) => {

                let perInstallment = Number($('#per_installment').val());
                let totalInstallment = Number($('#total_installment').val());
                let interestRate = Number($('#interest_rate').val());

                let totalAmount = perInstallment * totalInstallment;
                let interest = totalAmount * interestRate / 100;

                if (perInstallment && totalInstallment && interestRate) {
                    $('#final_amount').val(totalAmount);
                    $('#user_profit').val(interest);
                    $('.deposit-amount').removeClass('d-none');
                    $('.deposit-amount span').text(totalAmount + interest);
                }
            });

        })(jQuery);

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/dpsplan/create.blade.php ENDPATH**/ ?>