<header class="navbar navbar-expand-xl navbar-light d-print-none">
    <div class="container-xl">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu">
            <span class="navbar-toggler-icon"></span>
        </button>
        <h1 class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal pe-0 pe-md-3">
            <a href="<?php echo e(route('front.index')); ?>">
                <img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" width="110" height="32" alt="Logo"
                     class="navbar-brand-image">
            </a>
        </h1>
        <div class="navbar-nav flex-row order-md-last">
            <div class="flex align-items-center">
                <?php if(session('admin.impersonated_user_id')): ?>
                    <div class="badge badge-danger me-2 mt-3">
                        <?php echo e(__('Inspector')); ?>

                    </div>
                <?php endif; ?>
            </div>
            <div class="me-2">
                <?php if(auth()->user()->kyc_status==1): ?>
                    <div class="border rounded border-success text-success fw-bold py-1 px-3 mt-2">
                        <strong class="text-uppercase small">KYC Verified</strong>
                    </div>
                <?php else: ?>
                    <div class="border rounded border-warning text-warning fw-bold py-1 px-3 mt-2">
                        <strong class="text-uppercase small">KYC Unverified</strong>
                    </div>
                <?php endif; ?>
            </div>
            <div class="change-language me-2">
                <select name="currency" class="currency selectors nice language-bar">
                    <?php $__currentLoopData = DB::table('currencies')->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option
                            value="<?php echo e(route('front.currency',$currency->id)); ?>" <?php echo e(Session::has('currency') ? ( Session::get('currency') == $currency->id ? 'selected' : '' ) : (DB::table('currencies')->where('is_default','=',1)->first()->id == $currency->id ? 'selected' : '')); ?>>
                            <?php echo e($currency->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="me-2">
                <div class="border rounded bg-primary text-white fw-bold py-1 px-3 mt-2">
                    <strong class="text-uppercase small"><?php echo e(ucFirst(auth()->user()->account_type)); ?></strong>
                </div>
            </div>
            <a href="?theme=dark" class="nav-link px-0 hide-theme-dark" title="Enable dark mode"
               data-bs-toggle="tooltip" data-bs-placement="bottom">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
                     stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <path d="M12 3c.132 0 .263 0 .393 0a7.5 7.5 0 0 0 7.92 12.446a9 9 0 1 1 -8.313 -12.454z"/>
                </svg>
            </a>
            <a href="?theme=light" class="nav-link px-0 hide-theme-light" title="Enable light mode"
               data-bs-toggle="tooltip" data-bs-placement="bottom">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
                     stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <circle cx="12" cy="12" r="4"/>
                    <path
                        d="M3 12h1m8 -9v1m8 8h1m-9 8v1m-6.4 -15.4l.7 .7m12.1 -.7l-.7 .7m0 11.4l.7 .7m-12.1 -.7l-.7 .7"/>
                </svg>
            </a>
            <div class="nav-item dropdown">
                <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown"
                   aria-label="Open user menu">
                    <span class="avatar avatar-sm"
                          style="background-image: url(<?php echo e(auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/user/img/user.jpg')); ?>)"></span>
                    <div class="d-none d-xl-block ps-2">
                        <div><?php echo e(auth()->user()->name . ' ' . auth()->user()->last_name); ?></div>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <a href="<?php echo e(route('user.profile.index')); ?>" class="dropdown-item"><?php echo e(__('Edit Profile')); ?></a>
                    <a href="<?php echo e(route('user.change.password.form')); ?>"
                       class="dropdown-item"><?php echo e(__('Change Password')); ?></a>
                    <?php if(session('admin.impersonated_user_id')): ?>
                        <a href="<?php echo e(route('user.logout', ['to'=>'admin'])); ?>"
                           class="dropdown-item"><?php echo e(__('Logout / Back to Admin')); ?></a>
                        <?php if(session('admin.logged_in_user_id')): ?>
                            <a href="<?php echo e(route('user.logout')); ?>"
                               class="dropdown-item"><?php echo e(__('Logout / Back to User')); ?></a>
                        <?php else: ?>
                            <a href="<?php echo e(route('user.logout')); ?>" class="dropdown-item"><?php echo e(__('Logout')); ?></a>
                        <?php endif; ?>
                    <?php else: ?>
                        <a href="<?php echo e(route('user.logout')); ?>" class="dropdown-item"><?php echo e(__('Logout')); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/includes/user/header.blade.php ENDPATH**/ ?>