

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Edit Plan')); ?> <a class="btn btn-primary btn-rounded btn-sm"
                                                                          href="<?php echo e(route('admin.bank.plan.index')); ?>"><i
                        class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Bank Plan')); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Edit Plan Form')); ?></h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                         style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
                    <form class="geniusform" action="<?php echo e(route('admin.bank.plan.update',$data->id)); ?>" method="POST"
                          enctype="multipart/form-data">

                        <?php echo $__env->make('includes.admin.form-both', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title"><?php echo e(__('Title')); ?></label>
                                    <input type="text" class="form-control" id="title" name="title"
                                           placeholder="<?php echo e(__('Enter Title')); ?>" value="<?php echo e($data->title); ?>" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount"><?php echo e(__('Price')); ?></label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                           placeholder="<?php echo e(__('Enter Amount')); ?>" min="0" value="<?php echo e($data->amount); ?>"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="daily_send"><?php echo e(__('Maximum Send Money')); ?> (<?php echo e(__('Daily')); ?>)</label>
                                    <input type="number" class="form-control" id="daily_send" name="daily_send"
                                           placeholder="<?php echo e(__('ex.1000')); ?>" min="0" value="<?php echo e($data->daily_send); ?>"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="monthly_send"><?php echo e(__('Maximum Send Money')); ?> (<?php echo e(__('Monthly')); ?>

                                        )</label>
                                    <input type="number" class="form-control" id="monthly_send" name="monthly_send"
                                           placeholder="<?php echo e(__('ex.10000')); ?>" min="0" value="<?php echo e($data->monthly_send); ?>"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="daily_receive"><?php echo e(__('Maximum Request Money')); ?> (<?php echo e(__('Daily')); ?>

                                        )</label>
                                    <input type="number" class="form-control" id="daily_receive" name="daily_receive"
                                           placeholder="<?php echo e(__('ex.1000')); ?>" min="0" value="<?php echo e($data->daily_receive); ?>"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="monthly_receive"><?php echo e(__('Maximum Request Money')); ?> (<?php echo e(__('Monthly')); ?>

                                        )</label>
                                    <input type="number" class="form-control" id="monthly_receive"
                                           name="monthly_receive" placeholder="<?php echo e(__('ex.10000')); ?>" min="0"
                                           value="<?php echo e($data->monthly_receive); ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="daily_withdraw"><?php echo e(__('Maximum Withdraw Amount')); ?> (<?php echo e(__('Daily')); ?>

                                        )</label>
                                    <input type="number" class="form-control" id="daily_withdraw" name="daily_withdraw"
                                           placeholder="<?php echo e(__('ex.1000')); ?>" min="0" value="<?php echo e($data->daily_withdraw); ?>"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="monthly_withdraw"><?php echo e(__('Maximum Withdraw Amount')); ?>

                                        (<?php echo e(__('Monthly')); ?>)</label>
                                    <input type="number" class="form-control" id="monthly_withdraw"
                                           name="monthly_withdraw" placeholder="<?php echo e(__('ex.10000')); ?>" min="0"
                                           value="<?php echo e($data->monthly_withdraw); ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="days"><?php echo e(__('Days')); ?></label>
                                    <input type="number" class="form-control" id="days" name="days"
                                           placeholder="<?php echo e(__('Enter Days')); ?>" min="0" value="<?php echo e($data->days); ?>"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="loan_amount"><?php echo e(__('Maximum Loan Amount')); ?> (<?php echo e(__('Monthly')); ?>

                                        )</label>
                                    <input type="number" class="form-control" id="loan_amount" name="loan_amount"
                                           placeholder="<?php echo e(__('Loan Amount')); ?>" min="0"
                                           value="<?php echo e($data->loan_amount); ?>" required>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[personal][fixed]"><?php echo e(__('Personal')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="send_money_charge[personal][fixed]"
                                           name="send_money_charge[personal][fixed]" placeholder="<?php echo e(__('0')); ?>" min="0"
                                           value="<?php echo e($data->send_money_charge->personal->fixed??0); ?>" step="any"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[personal][percent]"><?php echo e(__('Personal')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control" id="send_money_charge[personal][percent]"
                                           name="send_money_charge[personal][percent]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0" value="<?php echo e($data->send_money_charge->personal->percent??0); ?>"
                                           step="any" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[agent][fixed]"><?php echo e(__('Agent')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="send_money_charge[agent][fixed]"
                                           name="send_money_charge[agent][fixed]" placeholder="<?php echo e(__('0')); ?>" min="0"
                                           value="<?php echo e($data->send_money_charge->agent->fixed??0); ?>" step="any" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[agent][percent]"><?php echo e(__('Agent')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control" id="send_money_charge[agent][percent]"
                                           name="send_money_charge[agent][percent]" placeholder="<?php echo e(__('0')); ?>" min="0"
                                           value="<?php echo e($data->send_money_charge->agent->percent??0); ?>" step="any"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[merchant][fixed]"><?php echo e(__('Merchant')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="send_money_charge[merchant][fixed]"
                                           name="send_money_charge[merchant][fixed]" placeholder="<?php echo e(__('0')); ?>" min="0"
                                           value="<?php echo e($data->send_money_charge->merchant->fixed??0); ?>" step="any"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="send_money_charge[merchant][percent]"><?php echo e(__('Merchant')); ?> <?php echo e(__('Send Money')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control" id="send_money_charge[merchant][percent]"
                                           name="send_money_charge[merchant][percent]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0" value="<?php echo e($data->send_money_charge->merchant->percent??0); ?>"
                                           step="any" required>
                                </div>
                            </div>
                        </div>

                        <div class="row d-none">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[personal][fixed]"><?php echo e(__('Personal')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="bank_transfer_charge[personal][fixed]"
                                           name="bank_transfer_charge[personal][fixed]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0"
                                           value="<?php echo e($data->bank_transfer_charge->personal->fixed??0); ?>" step="any"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[personal][percent]"><?php echo e(__('Personal')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control"
                                           id="bank_transfer_charge[personal][percent]"
                                           name="bank_transfer_charge[personal][percent]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0" value="<?php echo e($data->bank_transfer_charge->personal->percent??0); ?>"
                                           step="any" required>
                                </div>
                            </div>
                        </div>

                        <div class="row d-none">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[agent][fixed]"><?php echo e(__('Agent')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="bank_transfer_charge[agent][fixed]"
                                           name="bank_transfer_charge[agent][fixed]" placeholder="<?php echo e(__('0')); ?>" min="0"
                                           value="<?php echo e($data->bank_transfer_charge->agent->fixed??0); ?>" step="any"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[agent][percent]"><?php echo e(__('Agent')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control" id="bank_transfer_charge[agent][percent]"
                                           name="bank_transfer_charge[agent][percent]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0"
                                           value="<?php echo e($data->bank_transfer_charge->agent->percent??0); ?>" step="any"
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3 d-none">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[merchant][fixed]"><?php echo e(__('Merchant')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Fixed Charge')); ?></label>
                                    <input type="number" class="form-control" id="bank_transfer_charge[merchant][fixed]"
                                           name="bank_transfer_charge[merchant][fixed]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0"
                                           value="<?php echo e($data->bank_transfer_charge->merchant->fixed??0); ?>" step="any"
                                           required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        for="bank_transfer_charge[merchant][percent]"><?php echo e(__('Merchant')); ?> <?php echo e(__('Bank Transfer')); ?> <?php echo e(__('Percent Charge')); ?>

                                        (%)</label>
                                    <input type="number" class="form-control"
                                           id="bank_transfer_charge[merchant][percent]"
                                           name="bank_transfer_charge[merchant][percent]" placeholder="<?php echo e(__('0')); ?>"
                                           min="0" value="<?php echo e($data->bank_transfer_charge->merchant->percent??0); ?>"
                                           step="any" required>
                                </div>
                            </div>
                        </div>


                        <div class="featured-keyword-area">
                            <div class="lang-tag-top-filds" id="lang-section">
                                <?php if($attributes): ?>
                                    <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="lang-area mb-3">
                                            <span class="remove lang-remove"><i class="fas fa-times"></i></span>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <input type="text" class="form-control" name="attribute[]"
                                                           placeholder="<?php echo e(__('Enter Plan Attribute')); ?>"
                                                           value="<?php echo e($data); ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                            </div>

                            <a href="javascript:;" id="lang-btn" class="add-fild-btn d-flex justify-content-center"><i
                                    class="icofont-plus"></i> <?php echo e(__('Add Attribute')); ?></a>
                        </div>

                        <button type="submit" id="submit-btn"
                                class="btn btn-primary w-100 mt-2"><?php echo e(__('Submit')); ?></button>

                    </form>
                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        "use strict";

        function isEmpty(el) {
            return !$.trim(el.html())
        }


        $("#lang-btn").on('click', function () {

            $("#lang-section").append('' +
                '<div class="lang-area mb-3">' +
                '<span class="remove lang-remove"><i class="fas fa-times"></i></span>' +
                '<div class="row">' +
                '<div class="col-md-12">' +
                '<input type="text" class="form-control" name="attribute[]" placeholder="<?php echo e(__('Enter Plan Attribute')); ?>" value="" required>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '');

        });

        $(document).on('click', '.lang-remove', function () {

            $(this.parentNode).remove();

        });

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/bankplan/edit.blade.php ENDPATH**/ ?>