

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card p-3 py-4 px-sm-4">
                        <?php if ($__env->exists('includes.flash')) echo $__env->make('includes.flash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <form id="request-form" action="<?php echo e(route('user.profile.update')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6 mx-auto">
                                    <div class="form-group">
                                        <label class="font-weight-bold"><?php echo e(__('Set Image')); ?> </label>
                                        <div class="wrapper-image-preview">
                                            <div class="box">
                                                <div class="back-preview-image"
                                                    style="background-image: url('<?php echo e(auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/user/img/user.jpg')); ?>');">
                                                </div>
                                                <div class="upload-options">
                                                    <label class="img-upload-label" for="img-upload"> <i
                                                            class="fa fa-camera"></i> <?php echo e(__('Upload Picture')); ?>

                                                    </label>
                                                    <input id="img-upload" type="file" class="image-upload"
                                                        name="photo">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('User Name')); ?></label>
                                        <input name="name" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('User Name')); ?>" type="text" value="<?php echo e($user->name); ?>"
                                            required readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('Last Name')); ?></label>
                                        <input name="last_name" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Last Name')); ?>" type="text" value="<?php echo e($user->last_name); ?>"
                                            required readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" hx-target="this" hx-swap="outerHTML">
                                        <label class="form-label required"><?php echo e(__('Email Address')); ?></label>
                                        <div class="input-group">
                                            <input name="email" class="form-control form--control" autocomplete="off"
                                                placeholder="<?php echo e(__('Email Address')); ?>" type="email"
                                                value="<?php echo e($user->email); ?>" required readonly id="email_address">
                                            <?php if($user->email_verified_at): ?>
                                                <div class="input-group-text text-success fw-bold"> Verified</div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if(!$user->email_verified_at): ?>
                                            <div class="mt-1">
                                                <a href="javascript:void(0)"
                                                    hx-post="<?php echo e(route('user.profile.send-email-otp')); ?>"
                                                    hx-include="#email_address"
                                                    @htmx:before-send="$el.setAttribute('disabled', true)"
                                                    class="text-decoration-none">
                                                    <span class="htmx-hide"> Verify Email Address </span>
                                                    <span class="htmx-indicator">
                                                        <span class="spinner-border spinner-border-sm"></span>
                                                        Sending OTP...
                                                    </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" hx-target="this" hx-swap="outerHTML">
                                        <label class="form-label required"><?php echo e(__('Phone Number')); ?></label>
                                        <div class="input-group">
                                            <input name="phone" class="form-control form--control" autocomplete="off"
                                                placeholder="<?php echo e(__('Phone Number')); ?>" type="tel"
                                                value="<?php echo e($user->phone); ?>" required id="phone_number" <?php if($user->phone_verified_at): echo 'readonly'; endif; ?>>
                                            <?php if($user->phone_verified_at): ?>
                                                <div class="input-group-text text-success fw-bold"> Verified</div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if(!$user->phone_verified_at): ?>
                                            <div class="mt-1">
                                                
                                                <a href="javascript:void(0)"
                                                    hx-post="<?php echo e(route('user.profile.send-phone-otp')); ?>"
                                                    hx-include="#phone_number"
                                                    @htmx:before-send="$el.setAttribute('disabled', true)"
                                                    class="text-decoration-none">
                                                    <span class="htmx-hide"> Verify Phone Number </span>
                                                    <span class="htmx-indicator">
                                                        <span class="spinner-border spinner-border-sm"></span>
                                                        Sending OTP...
                                                    </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('Address')); ?></label>
                                        <input name="address" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Address')); ?>" type="text"
                                            value="<?php echo e($user->address); ?>" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('City')); ?></label>
                                        <input name="city" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('City')); ?>" type="text"
                                            value="<?php echo e($user->city); ?>" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('Zip')); ?></label>
                                        <input name="zip" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Zip')); ?>" type="text" value="<?php echo e($user->zip); ?>"
                                            required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label "><?php echo e(__('Country')); ?></label>
                                        <input name="country" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Country')); ?>" type="text"
                                            value="<?php echo e($user->country); ?>" >
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo e(__('Fax')); ?></label>
                                        <input name="fax" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Fax')); ?>" type="text"
                                            value="<?php echo e($user->fax); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label "><?php echo e(__('Telegram')); ?></label>
                                        <input name="telegram" class="form-control form--control" autocomplete="off"
                                            placeholder="<?php echo e(__('Telegram')); ?>" type="text"
                                            value="<?php echo e($user->telegram); ?>" >
                                    </div>
                                </div>
                            </div>


                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary submit-btn"><?php echo e(__('Submit')); ?></button>
                            </div>


                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if (isset($component)) { $__componentOriginalaeff4b44922fb48bfa886b58bb8c2797 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.htmx-alpine','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('htmx-alpine'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797)): ?>
<?php $attributes = $__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797; ?>
<?php unset($__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaeff4b44922fb48bfa886b58bb8c2797)): ?>
<?php $component = $__componentOriginalaeff4b44922fb48bfa886b58bb8c2797; ?>
<?php unset($__componentOriginalaeff4b44922fb48bfa886b58bb8c2797); ?>
<?php endif; ?>

<?php $__env->startPush('js'); ?>
    <script type="text/javascript">
        'use strict';

        $('.edit-profile').on('click', function() {
            $('.upload').click();

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/user/profile.blade.php ENDPATH**/ ?>