

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Add New Plan')); ?> <a class="btn btn-primary btn-rounded btn-sm"
                                                                             href="<?php echo e(route('admin.fdr.plan.index')); ?>"><i
                        class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.fdr.plan.index')); ?>"><?php echo e(__('FDR Plan')); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Add New Plan Form')); ?></h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                         style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
                    <form class="geniusform" action="<?php echo e(route('admin.fdr.plan.store')); ?>" method="POST"
                          enctype="multipart/form-data">

                        <?php echo $__env->make('includes.admin.form-both', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title"><?php echo e(__('Title')); ?></label>
                                    <input type="text" class="form-control" id="title" name="title"
                                           placeholder="<?php echo e(__('Enter Title')); ?>" value="" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interest_rate"><?php echo e(__('Interest Rate of Total Deposit')); ?> (%)</label>
                                    <input type="number" class="form-control" id="interest_rate" name="interest_rate"
                                           placeholder="<?php echo e(__('Interest Rate of Total Deposit')); ?>" min="1" value=""
                                           required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interval_type"><?php echo e(__('Interest Interval Type')); ?></label>
                                    <select name="interval_type" class="form-control" id="interval_type">
                                        <option value="fixed"> <?php echo e(__('Fixed')); ?> </option>
                                        <option value="partial"> <?php echo e(__('Partial')); ?> </option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="matured_days"><?php echo e(__('Locked In Period')); ?></label>
                                    <input type="number" class="form-control" id="matured_days" name="matured_days"
                                           placeholder="<?php echo e(__('Locked In Period')); ?>" min="1" value="" required>
                                </div>
                            </div>
                        </div>

                        <div class="row interval_time d-none">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="interest_interval"><?php echo e(__('Interval Time')); ?></label>
                                    <input type="number" class="form-control" id="interest_interval"
                                           name="interest_interval" placeholder="<?php echo e(__('Interval Time')); ?>" min="1"
                                           value="">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_amount"><?php echo e(__('Minimum Amount')); ?> (<?php echo e($currency->name); ?>)</label>
                                    <input type="number" class="form-control" id="min_amount" name="min_amount"
                                           placeholder="<?php echo e(__('Minimum Amount')); ?>" min="1" value="" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_amount"><?php echo e(__('Maximum Amount')); ?> (<?php echo e($currency->name); ?>)</label>
                                    <input type="number" class="form-control" id="max_amount" name="max_amount"
                                           placeholder="<?php echo e(__('Maximum Amount')); ?>" min="1" value="" required>
                                </div>
                            </div>
                        </div>

                        <button type="submit" id="submit-btn" class="btn btn-primary w-100"><?php echo e(__('Submit')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $("#interval_type").on("change", function () {
                if ($(this).val() == 'partial') {
                    $(".interval_time").removeClass('d-none');
                } else {
                    $(".interval_time").addClass('d-none');
                }
            })

        })(jQuery);

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/2/core/resources/views/admin/fdrplan/create.blade.php ENDPATH**/ ?>