<?php

use App\Models\Admin;
use App\Models\Currency;
use App\Models\LoginLogs;
use Illuminate\Support\Str;
use App\Classes\GeniusMailer;
use App\Models\Generalsetting;
use Illuminate\Support\Facades\DB;
use App\Models\StatusChangeHistory;
use App\Models\CustomerNotification;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Laravel\Facades\Image;

require_once 'sms_helpers.php';

if (!function_exists('globalCurrency')) {
    function globalCurrency()
    {
        $currency = Session::get('currency') ? DB::table('currencies')->where('id', '=', Session::get('currency'))->first() : DB::table('currencies')->where('is_default', '=', 1)->first();
        return $currency;
    }
}

if (!function_exists('showPrice')) {
    function showPrice($price, $currency)
    {
        $gs = Generalsetting::first();

        $price = round(($price) * $currency->value, 2);
        if ($gs->currency_format == 0) {
            return $currency->sign . number_format($price, 2);
        } else {
            return number_format($price, 2) . $currency->sign;
        }
    }
}

if (!function_exists('showNameAmount')) {
    function showNameAmount($amount)
    {
        $gs = Generalsetting::first();
        $currency = globalCurrency();

        $price = round($amount * $currency->value, 2);
        if ($gs->currency_format == 0) {
            return $currency->name . ' ' . $price;
        } else {
            return $price . ' ' . $currency->name;
        }
    }
}

if (!function_exists('showAmountSign')) {
    function showAmountSign($amount)
    {
        $gs = Generalsetting::first();
        $currency = globalCurrency();

        $price = round(($amount) * $currency->value, 2);
        if ($gs->currency_format == 0) {
            return $currency->name . ' ' . $price;
        } else {
            return $price . ' ' . $currency->sign;
        }
    }
}

if (!function_exists('convertedAmount')) {
    function convertedAmount($price)
    {
        $currency = globalCurrency();

        $price = round($price * $currency->value, 2);
        return $price;
    }
}

if (!function_exists('convertedApiAmount')) {
    function convertedApiAmount($price, $currencyId)
    {
        $currency = Currency::findOrFail($currencyId);

        $price = round($price * $currency->value, 2);
        return $price;
    }
}

if (!function_exists('apiCurrencyAmount')) {
    function apiCurrencyAmount($amount, $currencyId)
    {
        $currency = Currency::findOrFail($currencyId);
        return $amount / $currency->value;
    }
}

if (!function_exists('apiConvertedAmount')) {
    function apiConvertedAmount($amount)
    {
        $user = auth()->user();

        $gs = Generalsetting::first();
        $currency = Currency::findOrFail($user->currency_id);

        $price = round($amount * $currency->value, 2);
        if ($gs->currency_format == 0) {
            return $currency->name . ' ' . $price;
        } else {
            return $price . ' ' . $currency->sign;
        }
    }
}

if (!function_exists('apiConvertedCurrencyAmount')) {
    function apiConvertedCurrencyAmount($amount, $currencyId)
    {
        $gs = Generalsetting::first();
        $currency = Currency::findOrFail($currencyId);

        $price = round($amount * $currency->value, 2);
        if ($gs->currency_format == 0) {
            return $currency->name . ' ' . $price;
        } else {
            return $price . ' ' . $currency->sign;
        }
    }
}

if (!function_exists('requestFilter')) {
    function requestFilter($name)
    {
        return str_replace(' ', '_', $name);
    }
}

if (!function_exists('baseCurrencyAmount')) {
    function baseCurrencyAmount($amount)
    {
        $currency = globalCurrency();
        return $amount / $currency->value;
    }
}

if (!function_exists('convertedPrice')) {
    function convertedPrice($price, $currency)
    {
        return $price * $currency->value;
    }
}

if (!function_exists('defaultCurr')) {
    function defaultCurr()
    {
        return Currency::where('is_default', '=', 1)->first();
    }
}

if (!function_exists('notifyAdmins')) {
    function notifyAdmins($message, $type = 'info'): void
    {
        try {
            $admins = Admin::all();
            foreach ($admins as $admin) {
                $admin->notify(new App\Notifications\AdminNotificaton($message, $type));
            }
        } catch (Exception) {
        }
    }
}

if (!function_exists('amount_format')) {
    function amount_format($amount, $decimals = 2): string
    {
        return number_format(round($amount, $decimals), $decimals);
    }
}

if (!function_exists('send_email_temp')) {
    function send_email_temp($receiver, $data = null)
    {
        $gs = Generalsetting::first();

        if ($data && $gs->is_smtp == 1) {
            $mailer = new GeniusMailer();
            $mailer->sendAutoMail($data);
        }
    }
}
if (!function_exists('send_email_php')) {
    function send_email_php($receiver, $data = null)
    {
        $gs = Generalsetting::first();
        $to = $receiver->email;
        $subject = " Money send successfully.";
        $msg = "Hello " . $receiver->name . "!\nMoney send successfully.\nThank you.";
        $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
        mail($to, $subject, $msg, $headers);
    }
}
if (!function_exists('storeScaleDownImage')) {
    function storeScaleDownImage($file, $path, $fileName = null, $maxWidth = 600): string
    {
        $ext = $file->getClientOriginalExtension();
        if (is_null($fileName)) {
            $fileName = time() . Str::random(4) . ".$ext";
        }

        $image = Image::read($file);

        $scaleWidth = $maxWidth;
        $ratio = $image->width() / $image->height();
        if ($ratio < 1) {
            $scaleWidth = $maxWidth * $ratio;
        }

        $image->scaleDown($scaleWidth);

        Storage::disk('assets')->put(
            trim($path, '/') . "/$fileName",
            $image->encodeByExtension($ext, 70)
        );

        return $fileName;
    }
}

if (!function_exists('storeUserLog')) {
    function storeUserLog($userAgent, $ip, $userId)
    {
        // ----------------- DEVICE DETECTION -----------------
        if (preg_match('/iPhone/i', $userAgent)) {
            $device = 'iPhone';
        } elseif (preg_match('/iPad|Tablet/i', $userAgent)) {
            $device = 'Tablet';
        } elseif (preg_match('/Android/i', $userAgent)) {
            $device = preg_match('/Mobile/i', $userAgent) ? 'Android Mobile' : 'Android Tablet';
        } elseif (preg_match('/Mobile/i', $userAgent)) {
            $device = 'Mobile';
        } else {
            $device = 'Desktop';
        }

        // ----------------- BROWSER DETECTION -----------------
        if (preg_match('/Edg/i', $userAgent)) {
            $browser = 'Microsoft Edge';
        } elseif (preg_match('/Brave/i', $userAgent)) {
            $browser = 'Brave';
        } elseif (preg_match('/OPR/i', $userAgent) || preg_match('/Opera/i', $userAgent)) {
            $browser = 'Opera';
        } elseif (preg_match('/Chrome/i', $userAgent)) {
            $browser = 'Chrome';
        } elseif (preg_match('/Firefox/i', $userAgent)) {
            $browser = 'Firefox';
        } elseif (preg_match('/Safari/i', $userAgent)) {
            $browser = 'Safari';
        } elseif (preg_match('/MSIE|Trident/i', $userAgent)) {
            $browser = 'Internet Explorer';
        } else {
            $browser = 'Unknown';
        }

        $response = @file_get_contents("http://ip-api.com/json/{$ip}");
        $country = null;
        $city = null;
        if ($response) {
            $data = json_decode($response);
            $country = $data->country ?? null;
            $city = $data->city ?? null;
        }


      $userLog =  LoginLogs::create([
            'user_id' => $userId ?? 0,
            'ip'      => $ip,
            'device'  => $device,
            'browser' => $browser,
            'country' => $country,
            'city'    => $city,
        ]);

        return $userLog;
    }
}

if (!function_exists('statusHistory')) {
    function statusHistory($id, $type, $prevStatus, $currentStatus, $userId = null)
    {
        return StatusChangeHistory::create([
            'model_id'       => $id,
            'admin_id'       => auth()->guard('admin')->id(),
            'user_id'        => $userId,
            'type'           => $type,
            'privious_status'=> $prevStatus,
            'current_status' => $currentStatus,
        ]);
    }
}


if (!function_exists('notifyUser')) {
    function notifyUser($receiverId, $message,  $route, $notiFiableId)
    {
        return CustomerNotification::create([
            'receiver_id' => $receiverId,
            'route' => $route,
            'notifiable_type' => 'System Notification',
            'notifiable_id' => $notiFiableId,
            'data' => $message,
            'read_at' => null,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}