<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Generalsetting;
use App\Models\RegisterBonus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BonusController extends Controller
{
    public function index()
    {
        return view('admin.user.bonus');
    }

    public function update(Request $request)
    {
        $rules = [
            'bonus' => 'required',
            'status' => 'required'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(array('errors' => $validator->getMessageBag()->toArray()));
        }
        $bonus = RegisterBonus::first();
        $data = $request->all();
        $bonus->update($data);

       
        $msg = 'Bonus Updated Successfully.';
        return response()->json($msg);


    }

    public function statusUpdate(Request $request)
    {
        $input = $request->all();
        $data = Generalsetting::findOrFail(1);

        if ($request->isMethod("POST")) {
            $data->update($input);

            if ($request->ajax()) {
                $msg = 'Data Updated Successfully.';
                return response()->json($msg);
            }
        }

        if ($request->has('is_affilate')) {
            $data->is_affilate = $input['is_affilate'] ?? 0;
            $data->save();

            if ($request->ajax()) {
                $msg = 'Status Updated Successfully.';
                return response()->json($msg);
            }
        }

        if ($request->has('is_transaction_bonus')) {
            $data->is_transaction_bonus = $input['is_transaction_bonus'] ?? 0;
            $data->save();

            if ($request->ajax()) {
                $msg = 'Status Updated Successfully.';
                return response()->json($msg);
            }
        }

        return redirect()->back()->with('success', 'Data Updated Successfully.');
    }
}
