<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Role;
use Datatables;
use Illuminate\Http\Request;
use Validator;

class RoleController extends Controller
{
    private array $sections = [
        "Menu Builder",
        "Manage Customers",
        "Manage User KYC",
        "Loan Management",
        "DPS Management",
        "FDR Management",
        "Bank Plans",
        "Other Banks",
        "Money Transfer",
        "Manage Wire Transfer",
        "Request Money",
        "Transactions",
        "Deposit Requests",
        "Withdraw Requests",
        "Payment Settings",
        "All Messages",
        "Reports",
        "Manage Blogs",
        "General Setting",
        "Homepage Manage",
        "Email Setting",
        "Sms Setup",
        "Manage Roles",
        "Manage Staff",
        "Manage KYC Form",
        "Language Manage",
        "Fonts",
        "Menupage Setting",
        "Seo Tools",
        "Sitemaps",
        "Subscribers",
        "Manage Message Category"

    ];

    private array $subSections = [
        "Manage Customers" => [
            "User List",
            "Referral Bonus",
            "Admin Transaction",
            "User Logs"
        ],
        
        "Manage User KYC" => [
            "User KYC Info",
            "User KYC Modules",
        ],
        "Loan Management" => [
            "Loan Plans",
            "All Loans",
            "Pending Loan",
            "Running Loan",
            "Paid Loan",
            "Rejected Loan",
        ],
        "DPS Management" => [
            "Dps Plans",
            "All Dps",
            "Running Dps",
            "Matured Dps",
            "Closed Dps",
        ],
        "FDR Management" => [
            "Fdr Plans",
            "All Fdr",
            "Running Fdr",
            "Closed Fdr",
        ],
        "Money Transfer" => [
            "Own Bank Transfer",
            "Other Bank Transfer"
        ],
        "Manage Wire Transfer" => [
            "Wire Transfer Bank",
            "Wire Transfers",
        ],
        "Request Money" => [
            "All Money Request",
            "Money Request Setting",
        ],
        "Payment Settings" => [
            "Currencies",
            "Gateways / Funds",
        ],
        "Manage Blogs" => [
            "Categories",
            "Posts",
        ],
        "General Setting" => [
            "Logo",
            "Favicon",
            "Loader",
            "Breadcrum Banner",
            "Website Contents",
            "User Modules",
            "Error Banner",
            "Notice Add",
            "Maintenance",
            "Tawk Script",
            "Block Ip Data",
        ],
        "Email Setting" => [
            "Email Template",
            "Email Configuration",
            "Group Email",
        ],
        "Seo Tools" => [
            "Social Links",
        ],
    ];

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    //*** JSON Request
    public function datatables()
    {
        $datas = Role::orderBy('id', 'desc');
        //--- Integrating This Collection Into Datatables
        return Datatables::of($datas)
            ->addColumn('section', function (Role $data) {
                $details = str_replace('_', ' ', $data->section);
                $details = ucwords($details);
                return '<div>' . $details . '</div>';
            })
            ->addColumn('action', function (Role $data) {

                return '<div class="btn-group mb-1">
                                <button type="button" class="btn btn-primary btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                  ' . 'Actions' . '
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                  <a href="' . route('admin.role.edit', $data->id) . '"  class="dropdown-item">' . __("Edit") . '</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="dropdown-item" data-href="' . route('admin.role.delete', $data->id) . '">' . __("Delete") . '</a>
                                </div>
                              </div>';
            })
            ->rawColumns(['section', 'action'])
            ->toJson(); //--- Returning Json Data To Client Side
    }

    private function getSections()
    {
        $sections = [];
        foreach ($this->sections as $section) {
            $subSections = [];
            foreach ($this->subSections[$section] ?? [] as $subSection) {
                $subSections[]['name'] = $subSection;
            }
            $sections[] = [
                'name' => $section,
                'children' => $subSections,
            ];
        }

        return $sections;
    }

    //*** GET Request
    public function index()
    {
        return view('admin.role.index');
    }

    //*** GET Request
    public function create()
    {
        return view('admin.role.create', [
            'sections' => $this->getSections(),
        ]);
    }

    //*** POST Request
    public function store(Request $request)
    {
        $data = new Role();
        $input = $request->all();

        if (!empty($request->section)) {
            $input['section'] = implode(" , ", $request->section);
        } else {
            $input['section'] = '';
        }

        $data->fill($input)->save();

        $msg = __('New Data Added Successfully.') . '<a href="' . route('admin.role.index') . '">' . __('View Lists.') . '</a>';;
        return response()->json($msg);
    }

    //*** GET Request
    public function edit($id)
    {
        return view('admin.role.edit', [
            'data' => Role::findOrFail($id),
            'sections' => $this->getSections(),
        ]);
    }

    //*** POST Request
    public function update(Request $request, $id)
    {
        //--- Validation Section
        $rules = [
            'photo' => '',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(array('errors' => $validator->getMessageBag()->toArray()));
        }
        //--- Validation Section Ends

        //--- Logic Section
        $data = Role::findOrFail($id);
        $input = $request->all();
        if (!empty($request->section)) {
            $input['section'] = implode(" , ", $request->section);
        } else {
            $input['section'] = '';
        }
        $data->update($input);
        //--- Logic Section Ends

        //--- Redirect Section
        $msg = __('Data Updated Successfully.') . '<a href="' . route('admin.role.index') . '">' . __('View Lists.') . '</a>';
        return response()->json($msg);
        //--- Redirect Section Ends

    }

    //*** GET Request Delete
    public function destroy($id)
    {
        $data = Role::findOrFail($id);
        $data->delete();
        //--- Redirect Section
        $msg = __('Data Deleted Successfully.');
        return response()->json($msg);
        //--- Redirect Section Ends
    }
}
