<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\BalanceTransfer;
use App\Models\BankPlan;
use App\Models\Beneficiary;
use App\Models\Generalsetting;
use App\Models\OtherBank;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class OtherBankController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data['beneficiaries'] = Beneficiary::where('user_id', auth()->user()->id)->orderBy('id', 'desc')->paginate(10);
        return view('user.otherbank.index', $data);
    }

    public function othersend($id)
    {
        $data['data'] = Beneficiary::findOrFail($id);
        return view('user.otherbank.send', $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:0'
        ]);

        $user = auth()->user();
        if ($user->bank_plan_id === null) {
            return redirect()->back()->with('unsuccess', 'You have to buy a plan to withdraw.');
        }

        if (now()->gt($user->plan_end_date)) {
            return redirect()->back()->with('unsuccess', 'Plan Date Expired.');
        }

        $bank_plan = BankPlan::whereId($user->bank_plan_id)->first();
        $dailySend = BalanceTransfer::whereUserId(auth()->id())->whereDate('created_at', '=', date('Y-m-d'))->whereStatus(1)->sum('amount');
        $monthlySend = BalanceTransfer::whereUserId(auth()->id())->whereMonth('created_at', '=', date('m'))->whereStatus(1)->sum('amount');

        if ($dailySend > $bank_plan->daily_send) {
            return redirect()->back()->with('unsuccess', 'Daily send limit over.');
        }

        if ($monthlySend > $bank_plan->monthly_send) {
            return redirect()->back()->with('unsuccess', 'Monthly send limit over.');
        }


        $gs = Generalsetting::first();
        $otherBank = OtherBank::whereId($request->other_bank_id)->first();
        $dailyTransactions = BalanceTransfer::whereType('other')->whereUserId(auth()->user()->id)->whereDate('created_at', now())->get();
        $monthlyTransactions = BalanceTransfer::whereType('other')->whereUserId(auth()->user()->id)->whereMonth('created_at', now()->month())->get();

        if ($otherBank) {
            $cost = $otherBank->fixed_charge + ($request->amount / 100) * $otherBank->percent_charge;
            $finalAmount = $request->amount + $cost;

            if ($otherBank->min_limit > $request->amount) {
                return redirect()->back()->with('unsuccess', 'Request Amount should be greater than this');
            }

            if ($otherBank->max_limit < $request->amount) {
                return redirect()->back()->with('unsuccess', 'Request Amount should be less than this');
            }

            if ($user->balance < 0 && $finalAmount > $user->balance) {
                return redirect()->back()->with('unsuccess', 'Insufficient Balance!');
            }

            if ($otherBank->daily_maximum_limit <= $finalAmount) {
                return redirect()->back()->with('unsuccess', 'Your daily limitation of transaction is over.');
            }

            if ($otherBank->daily_maximum_limit <= $dailyTransactions->sum('final_amount')) {
                return redirect()->back()->with('unsuccess', 'Your daily limitation of transaction is over.');
            }

            if ($otherBank->daily_total_transaction <= count($dailyTransactions)) {
                return redirect()->back()->with('unsuccess', 'Your daily number of transaction is over.');
            }

            if ($otherBank->monthly_maximum_limit < $monthlyTransactions->sum('final_amount')) {
                return redirect()->back()->with('unsuccess', 'Your monthly limitation of transaction is over.');
            }

            if ($otherBank->monthly_total_transaction <= count($monthlyTransactions)) {
                return redirect()->back()->with('unsuccess', 'Your monthly number of transaction is over!');
            }

            if ($request->amount > $user->balance) {
                return redirect()->back()->with('unsuccess', 'Insufficient Account Balance.');
            }

            if (($request->amount + $cost) > $user->balance) {
                return redirect()->back()->with('unsuccess', 'Insufficient Account Balance.');
            }

            // $charge = $bank_plan->getBankTransferCharge(auth()->user());
            // $cost = $charge->fixed + ($request->amount / 100) * $charge->percent;

            // $charge = $bank_plan->getBankTransferCharge(auth()->user());
            // $cost = $otherBank->fixed_charge + ($request->amount / 100) * $otherBank->percent_charge;

           // dd($cost);

            $allinfo = [
                'sender_type' => $user->account_type ?? "",
                'reciver_type' =>  "Other Bank",
                "fixed_charge_amount" => $otherBank->fixed_charge,
                "percent_charge" => $otherBank->percent_charge ?? 0,
                "percent_charge_amount" => ($request->amount / 100) * $otherBank->percent_charge,
            ];

            $txnId = Str::random(4) . time();

            $data = new BalanceTransfer();
            $data->user_id = auth()->user()->id;
            $data->transaction_no = $txnId;
            $data->other_bank_id = $request->other_bank_id;
            $data->beneficiary_id = $request->beneficiary_id;
            $data->type = 'other';
            $data->cost = $cost;
            $data->amount = $request->amount;
            $data->final_amount = $finalAmount;
            $data->status = 0;
            $data->save();

            $user->decrement('balance', $finalAmount);
            $trans = new Transaction();
            $trans->email = $user->email;
            $trans->amount = $request->amount;
            $trans->type = "Send Money";
            $trans->profit = "minus";
            $trans->txnid = $txnId;
            $trans->user_id = $user->id;
             $trans->sender_id = $user->id;
            $trans->charge = $cost;
            $trans->user_available_balance = $user->balance;
            $trans->all_info = json_encode($allinfo);
            $trans->save();

            $msg = "$user->name $user->last_name Created a Other Bank Transfer Transcation";
            notifyAdmins($msg);
            
            return redirect()->back()->with('success', 'Money Send successfully.');
        }
    }
}
