<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\BankPlan;
use App\Models\PaymentGateway;

class PricingPlanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data['packages'] = BankPlan::all();
        return view('user.package.index', $data);
    }

    public function subscription($id)
    {
        $data['data'] = BankPlan::findOrFail($id);
        $data['availableGatways'] = ['flutterwave', 'authorize.net', 'razorpay', 'mollie', 'paytm', 'instamojo', 'stripe', 'paypal', 'bkash'];
        $data['gateways'] = PaymentGateway::OrderBy('id', 'desc')->where('bank_plan_status',1)->get();
       // dd($data);
        return view('user.package.details', $data);
    }
}
