<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Generalsetting;
use Symfony\Component\HttpFoundation\Response;


class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $settings = Generalsetting::first();
        
        if ($settings && $settings->maintenance_mode) {
            if ($request->is('admin/login') || 
                $request->is('admin/login/*') || 
                $request->is('admin/forgot') || 
                $request->is('admin/forgot-submit') || 
                $request->is('admin/change-password') || 
                $request->is('admin/change-password/*')) {
                return $next($request);
            }
            
            if (auth('admin')->check()) {
                return $next($request);
            }
            
            if ($request->expectsJson() || $request->is('api/*')) {
                return response()->json([
                    'error' => 'Site is currently under maintenance. Please try again later.',
                    'maintenance_mode' => true
                ], 503);
            }
            
            return response()->view('errors.maintenance', [], 503);
        }
        
        return $next($request);
    }
}