<?php


// app/Http/Middleware/CheckUserIp.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckUserIp
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $savedIp = session('user_ip');
            $currentIp = $request->ip();

            if ($savedIp && $savedIp !== $currentIp) {
                Auth::logout();
                session()->invalidate();
                session()->regenerateToken();

                return redirect()->route('user.login')
                    ->withErrors(['ip_changed' => 'Your IP address has changed, please login again.']);
            }
        }

        return $next($request);
    }
}
