<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UserSuspended
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(Request): (Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth('web')->check()) {
            $user = auth('web')->user();
            if ($user->is_suspended == '1') {
                return to_route('user.dashboard')->with('warning', 'Your Acount Suspended, please Contact For Support!');
            }
        }

        if (!$request->is([
            'user/withdraw*',
            'user/wire-transfer*',
            'user/beneficiaries*',
            'user/other-bank*',
            'user/send-money*',
            'user/request-money*',
        ])) {
            return $next($request);
        }


        return $next($request);
    }
}
