<?php

namespace App\Models;

use App\Helpers\Traits\AppNotifiable;
use Illuminate\Notifications\DatabaseNotification;

class AppNotification extends DatabaseNotification
{
    use AppNotifiable;

    protected $table = 'app_notifications';

    public function getGoto(): string
    {
        $params = [
            "ref" => "notification",
            "id" => $this->id,
        ];
        return match ($this->data['type']) {
            'user' => route('admin.user.index', $params),
            'deposit' => route('admin.deposits.index', $params),
            'withdraw' => route('admin.withdraw.index', $params),
            'message' => route('admin.user.message', $params),
            'kyc' => route('admin.kyc.info', ['user' => 'user']),
            'wiretransfer' => route('admin.wire.transfer.index'),
            'loan' => route('admin.loan.index'),
            'dps' => route('admin.dps.index'),
            'fdr' => route('admin.fdr.index'),
            default => '#',
        };
    }

    public function getMessage()
    {
        return $this->data['message'];
    }
}
