<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;

class PaymentMerchant extends Model
{
    protected $fillable = [
        'user_id',
        'merchant_id',
        'merchant_logo',
        'public_key',
        'secret_key',
        'status',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getMerchantLogoUrlAttribute(): string
    {
        if (empty($this->merchant_logo)) {
            return asset('assets/images/noimage.png');
        }

        return asset('assets/images/merchant/'.$this->merchant_logo);
    }

    public static function getKeys($userId): PaymentMerchant
    {
        $model = PaymentMerchant::where('user_id', $userId)->first();

        if (!$model) {
            $model = new PaymentMerchant();
            $model->user_id = $userId;
            $model->merchant_id = self::generateMerchantId();
            $model->public_key = "pub_".Str::random(40);
            $model->secret_key = "sec_".Str::random(40);
            $model->save();
        }
        if (empty($model->merchant_id)) {
            $model->merchant_id = self::generateMerchantId();
        }
        if (empty($model->public_key)) {
            $model->public_key = "pub_".Str::random(40);
        }
        if (empty($model->secret_key)) {
            $model->secret_key = "sec_".Str::random(40);
        }

        return $model;
    }

    public static function generateMerchantId(): string
    {
        return strtoupper(uniqid('M'));
    }
}
