<?php

namespace App\Models;

use App\Models\StatusChangeHistory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserLoan extends Model
{
    use HasFactory;

    protected $fillable = [
        'transaction_no',
        'user_id',
        'plan_id',
        'loan_amount',
        'per_installment_amount',
        'total_installment',
        'given_installment',
        'missed_installment_count',
        'paid_amount',
        'total_amount',
        'required_information',
    ];

    protected $dates = [
        'next_installment',
    ];

    public function plan()
    {
        return $this->belongsTo(LoanPlan::class)->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function lastHistory()
    {
        return $this->hasOne(StatusChangeHistory::class, 'model_id')
            ->where('type', 'loan')
            ->with('admin:id,name')
            ->latest('created_at');
    }

    public function histories()
    {
        return $this->hasMany(StatusChangeHistory::class, 'model_id')->where('type', 'loan')->with('admin:id,name')->orderBy('created_at', 'desc');
    }

    public function missedInstallments()
    {
        return $this->hasMany(LoanMissedInstallment::class, 'user_loan_id');
    }

    public function unpaidMissedInstallments()
    {
        return $this->hasMany(LoanMissedInstallment::class, 'user_loan_id')->where('is_paid', false);
    }
}
