<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WireTransfer extends Model
{
    use HasFactory;

    protected $guarded = ['*'];
  //   protected $fillable = ['charge'];

    public function bank()
    {
        return $this->belongsTo(WireTransferBank::class, 'wire_transfer_bank_id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function lastHistory()
    {
        return $this->hasOne(StatusChangeHistory::class, 'model_id')
            ->where('type', 'wire_transfer')
            ->with('admin:id,name')
            ->latest('created_at');
    }

    public function histories()
    {
        return $this->hasMany(StatusChangeHistory::class, 'model_id')
            ->where('type', 'wire_transfer')
            ->with('admin:id,name')
            ->orderBy('created_at', 'desc');
    }
}