<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class AdminHeaderNotification extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.admin-header-notification', [
            'items' => $this->getItems(),
            'unread' => auth('admin')->user()->unreadNotifications()->count(),
        ]);
    }

    private function getItems()
    {
        return auth('admin')->user()->unreadNotifications()->latest()->limit(10)->get();
    }
}
