<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_gateways', function (Blueprint $table) {
            $table->string('logo')->nullable()->after('name');
            $table->after('status', function (Blueprint $table) {
                $table->string('withdraw_status')->nullable();
                $table->string('withdraw_note')->nullable();
                $table->unsignedDecimal('withdraw_fee_fixed')->nullable();
                $table->unsignedDecimal('withdraw_fee_percentage')->nullable();
                $table->text('fund_note')->nullable();
                $table->decimal('fund_available', 12)->nullable();
                $table->unsignedDecimal('sending_rate')->nullable();
                $table->unsignedDecimal('receiving_rate')->nullable();
                $table->unsignedDecimal('min_limit')->nullable();
                $table->unsignedDecimal('max_limit')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_gateways', function (Blueprint $table) {
            //
        });
    }
};
