<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_transactions', function (Blueprint $table) {
            $table->uuid('id')->primary();;
            $table->string('merchant_id')->index();
            $table->decimal('amount', 15, 2);
            $table->string('currency', 3);
            $table->string('reference')->unique();
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled', 'refunded']);
            $table->json('customer_data')->nullable();
            $table->json('metadata')->nullable();
            $table->text('description')->nullable();
            $table->decimal('fee_amount', 10, 2)->default(0);
            $table->string('payment_link_id')->nullable();
            $table->bigInteger('payer_id')->unsigned()->index()->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_transactions');
    }
};
