<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_requests', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('merchant_id')->index();
            $table->string('request_id')->index();
            $table->decimal('amount', 15, 2);
            $table->string('currency', 3);
            $table->json('customer_data')->nullable();
            $table->json('metadata')->nullable();
            $table->text('description')->nullable();
            $table->string('return_url');
            $table->string('cancel_url');
            $table->string('webhook_url');
            $table->string('referrer')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_links');
    }
};
