@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Deposits') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>

                <li class="breadcrumb-item"><a href="{{ route('admin.deposits.index') }}">{{ __('Deposits') }}</a></li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <div class="col-lg-12">

            <div class="row g-3 mb-3">
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $pending ?? 0 }}</div>
                            <div class="text-muted">{{ __('Pending') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $complete ?? 0 }}</div>
                            <div class="text-muted">{{ __('Complete') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $cancelled ?? 0 }}</div>
                            <div class="text-muted">{{ __('Cancelled') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $processing ?? 0 }}</div>
                            <div class="text-muted">{{ __('Processing') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $onhold ?? 0 }}</div>
                            <div class="text-muted">{{ __('On Hold') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            @include('includes.admin.form-success')

            <div class="card mb-4 p-4">
                <div class="d-flex gap-2 justify-content-between">
                    <div style="display: flex;justify-content: space-between; gap: 5px;">
                        <div class="input-group">
                            <span class="input-group-text ">From</span>
                            <input type="date" class="form-control" name="from" id="from_date"
                                placeholder="From Date" />
                        </div>
                        <div class="input-group">
                            <span class="input-group-text ">To</span>
                            <input type="date" class="form-control" name="to" id="to_date"
                                placeholder="To Date" />
                        </div>
                        <div>
                            <button class="btn btn-primary d-block" id="applyBtn">
                                Apply
                            </button>
                        </div>
                    </div>

                    <div id="exportArea">
                           <a href="{{ route('admin.deposits.exportexcel') }}" class="btn btn-primary "
                                    id="excelDownload">
                                    Excel Download
                                </a>

                                   <a target="_blank" href="{{ route('admin.deposits.exportpdf') }}" class="btn btn-primary "
                                    id="pdfDownload">
                                    Pdf Download
                                </a>
                    </div>
                </div>


            </div>
            <div class="table-responsive p-3">
                <table id="geniustable" class="table table-hover" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr class="dt-column-filter">
                            <th class="p-1">

                            </th>
                            <th class="p-1"><input type="search" class="form-control"
                                    placeholder="{{ __('Deposit Number') }}" /></th>
                            <th class="p-1"><input type="search" class="form-control"
                                    placeholder="{{ __('Customer Name') }}" /></th>
                            <th class="p-1"><input type="search" class="form-control"
                                    placeholder="{{ __('Customer Email') }}" /></th>

                            <th class="p-1">
                                <select class="form-control">
                                    <option value=""> {{ __('All Method') }} </option>
                                    <option value="stripe">{{ __('Stripe') }}</option>
                                    <option value="paytm">{{ __('Paytm') }}</option>
                                    <option value="Manual">{{ __('Manual') }}</option>
                                    <option value="paypal">{{ __('Paypal') }}</option>
                                </select>
                            </th>
                            <th class="p-1"><input type="search" class="form-control"
                                    placeholder="{{ __('Amount') }}" />
                            </th>
                            <th class="p-1">
                                <select class="form-control">
                                    <option value="">{{ __('All') }}</option>
                                    <option value="pending">{{ __('Pending') }}</option>
                                    <option value="complete">{{ __('Complete') }}</option>
                                    <option value="canceled">{{ __('Cancelled') }}</option>
                                    <option value="processing">{{ __('Processing') }}</option>
                                    <option value="onhold">{{ __('On Hold') }}</option>
                                </select>
                            </th>
                            <th></th>
                            <th></th>
                        </tr>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th nowrap>{{ __('Deposit Number') }}</th>
                            <th nowrap>{{ __('Customer Name') }}</th>
                            <th nowrap>{{ __('Customer Email') }}</th>
                            <th>{{ __('Method') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th> {{ __('Last Status') }} </th>
                            <th>{{ __('View') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    </div>

    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog"
        aria-labelledby="statusModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Update Status') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to change the status.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>

                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-success btn-ok">{{ __('Update') }}</a>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Deposit Information</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="viewModalBody">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection



@section('scripts')
    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: true,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: {
                url: '{{ route('admin.deposits.datatables') }}',
                data: function(d) {
                    d.from_date = $('#from_date').val();
                    d.to_date = $('#to_date').val();
                }
            },
            columns: [{
                    data: 'created_at',
                    name: 'created_at',
                    orderable: true,
                },
                {
                    data: 'deposit_number',
                    name: 'deposit_number',
                    orderable: true,
                },
                {
                    data: 'customer_name',
                    name: 'customer_name',
                    orderable: true,
                },
                {
                    data: 'customer_email',
                    name: 'customer_email',
                    orderable: true,
                },
                {
                    data: 'method',
                    name: 'method',
                    orderable: true,
                },
                {
                    data: 'amount',
                    name: 'amount',
                    orderable: true,
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: true,
                    searchable: true
                },
                {
                    data: 'last_history',
                    // searchable: false,
                    orderable: false
                },
                {
                    data: 'view',
                    name: 'view',
                    orderable: false,
                    searchable: false
                },
            ],
            order: [
                [6, 'desc'],
                [0, 'desc']
            ],
            lengthMenu: [15, 30, 50, 75, 100, 500, 1000],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}"/>'
            }
        });

        //  Apply column filter
        $('#geniustable .dt-column-filter th').each(function(i) {
            $('input, select', this).on('keyup change', debounce(function() {
                if (table.column(i).search() !== this.value) {
                    table.column(i).search(this.value).draw()
                }
            }, 300)); // 300ms debounce delay
        });



        $(document).on('click', '.view-deposit', function() {
            $.ajax({
                url: $(this).data('url'),
                type: 'GET',
                success: function(response) {
                    $('#viewModalBody').html(response);
                }
            })
        });
    </script>

    {{-- <script>
        $('#applyBtn').on('click', function() {
            let from_date = $('#from_date').val();
            let to_date = $('#to_date').val();
            table.draw();
        });

        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            let from = $('#from_date').val();
            let to = $('#to_date').val();
            let createdAt = data[0]; // Assuming 'created_at' is in the first column (index 0)

            if (!from && !to) return true;

            const parseDate = (str) => {
                const [day, month, year] = str.split("-");
                return new Date(`${year}-${month}-${day}`);
            };

            const rowDate = parseDate(createdAt);

            if (from && !to) {
                return rowDate >= new Date(from);
            } else if (!from && to) {
                return rowDate <= new Date(to);
            } else if (from && to) {
                return rowDate >= new Date(from) && rowDate <= new Date(to);
            }

            return true;
        });
    </script> --}}
    <script>
        $('#applyBtn').on('click', function() {
    let from_date = $('#from_date').val();
    let to_date = $('#to_date').val();

    // Redraw the DataTable with new date filters
    table.draw();

    // Update export URLs with query parameters
    let excelUrl = '{{ route('admin.deposits.exportexcel') }}';
    let pdfUrl = '{{ route('admin.deposits.exportpdf') }}';

    if (from_date || to_date) {
        let query = '?';
        if (from_date) query += 'from=' + encodeURIComponent(from_date);
        if (to_date) query += (from_date ? '&' : '') + 'to=' + encodeURIComponent(to_date);

        $('#excelDownload').attr('href', excelUrl + query);
        $('#pdfDownload').attr('href', pdfUrl + query);
    } else {
        // If no filters selected, revert to default URLs
        $('#excelDownload').attr('href', excelUrl);
        $('#pdfDownload').attr('href', pdfUrl);
    }
});

    </script>
@endsection
