@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">
                {{ __('KYC Details') }}
                <a class="btn btn-primary btn-rounded btn-sm" href="{{route('admin.kyc.info','user')}}">
                    <i class="fas fa-arrow-left"></i>
                    {{ __('Back') }}
                </a>
            </h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('KYC') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            <form action="{{ route('admin.user.kyc', [$user->id, 1]) }}" method="post" id="kycReviewForm">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="special-box">
                            <div class="heading-area">
                                <h4 class="title">
                                    {{__('KYC Information')}}
                                </h4>
                            </div>
                            <div class="table-responsive-sm">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        @if($user->kyc_status==0 || request('edit'))
                                            <th width="1%">
                                                <div class="form-check-inline mr-0">
                                                    <input type="checkbox" name="rejected[]"
                                                           value="kyc_face"
                                                           class="form-check-input reject-checkbox"
                                                           style="width:1.25rem;height:1.25rem"/>
                                                </div>
                                            </th>
                                        @endif
                                        <th width="45%">KYC Face Video</th>
                                        <td width="9%">:</td>
                                        <td width="45%">
                                            <video src="{{ asset('assets/user/kyc/'.$user->kyc_face) }}" controls
                                                   width="300"></video>
                                        </td>
                                    </tr>
                                    @if ($kycInformations != null)
                                        @foreach ($kycInformations as $key=>$value)
                                            @php
                                                $keyAsTitle = ucwords(str_replace('_', ' ', $key));
                                            @endphp
                                            @if ($value[1] == 'file')
                                                <tr>
                                                    @if($user->kyc_status==0 || request('edit'))
                                                        <th width="1%">
                                                            <div class="form-check-inline mr-0">
                                                                <input type="checkbox" name="rejected[]"
                                                                       value="{{$key}}"
                                                                       class="form-check-input reject-checkbox"
                                                                       style="width:1.25rem;height:1.25rem"/>
                                                            </div>
                                                        </th>
                                                    @endif
                                                    <th width="45%">{{$keyAsTitle}}</th>
                                                    <td width="9%">:</td>
                                                    <td width="45%">
                                                        <a href="{{asset('assets/images/'.$value[0])}}" target="_blank">
                                                            <img src="{{asset('assets/images/'.$value[0])}}"
                                                                 class="img-thumbnail" style="max-height: 200px;">
                                                        </a><br>
                                                        <a href="{{asset('assets/images/'.$value[0])}}"
                                                           download>Download</a>
                                                    </td>
                                                </tr>
                                            @else
                                                <tr>
                                                    @if($user->kyc_status==0 || request('edit'))
                                                        <th width="1%">
                                                            <div class="form-check-inline mr-0">
                                                                <input type="checkbox" name="rejected[]"
                                                                       value="{{$key}}"
                                                                       class="form-check-input reject-checkbox"
                                                                       style="width:1.25rem;height:1.25rem"/>
                                                            </div>
                                                        </th>
                                                    @endif
                                                    <th width="45%">{{$keyAsTitle}}</th>
                                                    <td width="9%">:</td>
                                                    <td width="45%">{{ $value[0] }}</td>
                                                </tr>
                                            @endif
                                        @endforeach
                                        <tr>
                                            @if($user->kyc_status==0 || request('edit'))
                                                <th width="1%">
                                                    <div class="form-check-inline mr-0">
                                                        <input type="checkbox" name="user_dob"
                                                                value="{{$user->dob}}"
                                                                class="form-check-input reject-checkbox"
                                                                style="width:1.25rem;height:1.25rem"/>
                                                    </div>
                                                </th>
                                            @endif
                                            <th width="45%">Date of Birth</th>
                                            <td width="9%">:</td>
                                            <td width="45%">{{ \Carbon\Carbon::parse($user->dob)->format('d, F Y') }}</td>
                                        </tr>
                                    @else
                                        <p class="text-center mt-5">@lang('KYC NOT SUBMITTTED')</p>
                                    @endif

                                    </tbody>
                                </table>

                            </div>
                            <div class="footer-area">
                                @if ($kycInformations != null)
                                    @if ($user->kyc_status == 0 || request('edit'))
                                        <div>
                                            <button
                                                type="button"
                                                class="btn btn-primary kyc-update"
                                                data-href="{{ route('admin.user.kyc',['id1' => $user->id, 'id2' => 1]) }}"
                                                id="approveButton"
                                            >
                                                <i class="far fa-check-circle"></i> {{__('Approve')}}
                                            </button>
                                            <button
                                                type="button"
                                                class="btn btn-danger kyc-update ml-3"
                                                data-href="{{ route('admin.user.kyc',['id1' => $user->id, 'id2' => 2]) }}"
                                                id="rejectButton"
                                            >
                                                <i class="fas fa-minus-circle"></i> {{__('Reject')}}
                                            </button>
                                        </div>
                                        <div class="form-inline ml-3">
                                            <input
                                                type="text"
                                                name="reject_reason"
                                                class="form-control align-middle"
                                                placeholder="{{__('Reject Reason')}}"
                                            />
                                        </div>
                                        @if(request('edit'))
                                            <div>
                                                <a href="javascript:void(0)" onclick="history.go(-1)"
                                                   class="btn btn-secondary ml-3">{{__('Cancel Edit')}}</a>
                                            </div>
                                        @endif
                                    @else
                                        <div class="d-flex align-items-center">
                                            <strong>Status:</strong>
                                            @if($user->kyc_status==1)
                                                <span class="btn btn-success bg-success ml-3">{{__('Approved')}}</span>
                                            @else
                                                <span class="btn btn-danger bg-danger ml-3">{{__('Rejected')}}</span>
                                            @endif
                                            <a href="?edit=1" class="btn btn-primary ml-3"
                                               onclick="return confirm('Are you sure? You want to edit the KYC submission!')"
                                            >{{__('Edit')}}</a>
                                        </div>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @csrf
            </form>

        </div>
    </div>


    {{-- STATUS MODAL --}}
    <div class="modal fade status-modal" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalTitle"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __("Update Status") }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="text-center">{{ __("You are about to change the status.") }}</p>
                    <p class="text-center">{{ __("Do you want to proceed?") }}</p>
                </div>

                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
                    <a href="javascript:;" class="btn btn-success btn-submit">{{ __("Update") }}</a>
                </div>
            </div>
        </div>
    </div>
    {{-- STATUS MODAL ENDS --}}

@endsection

@section('scripts')
    <script>
        $(function () {
            $(document).on('click', '.kyc-update', function (e) {
                e.preventDefault();
                const actionUrl = $(this).data('href');
                $('#statusModal').modal('show');
                $('#kycReviewForm').attr('action', actionUrl);
            })
            $(document).on('click', '.btn-submit', function (e) {
                $('#kycReviewForm').submit();
            });
            $(document).on('change', '.reject-checkbox', function () {
                const checked = $('.reject-checkbox:checked').length;
                const totalCheckbox = $('.reject-checkbox').length;
                if (checked !== totalCheckbox) {
                    $('#approveButton').prop('disabled', true);
                }
                if (checked === totalCheckbox) {
                    $('#approveButton').prop('disabled', false);
                }
                if (checked > 0) {
                    $('#rejectButton').prop('disabled', false);
                }
            });

            if ($('.reject-checkbox:checked').length === 0) {
                $('#rejectButton').prop('disabled', true);
            }
        })
    </script>
@endsection
