@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Payment Gateway') }} <a
                    class="btn btn-primary btn-rounded btn-sm" href="{{ route('admin.payment.index') }}"><i
                        class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ route('admin.payment.index') }}">{{ __('Payment Gateways') }}</a>
                </li>
                <li class="breadcrumb-item"><a
                        href="{{ route('admin.payment.edit', $data->id) }}">{{ __('Edit Payment') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="card mb-4 mt-3">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Payment Form') }}</h6>
        </div>

        <div class="card-body">

            <form class="geniusform" action="{{ route('admin.payment.update', $data->id) }}" method="POST"
                  enctype="multipart/form-data">

                @include('includes.admin.form-both')

                {{ csrf_field() }}


                @if ($data->type == 'automatic')

                    <div class="form-group">
                        <label for="inp-name">{{ __('Name') }}</label>
                        <input type="text" class="form-control" id="inp-name" name="name"
                               placeholder="{{ __('Enter Name') }}" value="{{ $data->name }}" required>
                    </div>

                    <div class="d-flex align-items-center" style="gap: 1.5rem">
                        <div class="form-group" style="flex-grow: 1">
                            <label for="title">{{ __('Logo') }}</label>
                            <input type="file" class="form-control form-control-file" id="logo" name="logo"/>
                        </div>
                        @if (!empty($data->logo))
                            <div class="mt-2">
                                <img src="{{ asset('assets/images/' . $data->logo) }}" alt="Logo" height="70"
                                     style="max-width: 100px"/>
                            </div>
                        @endif
                    </div>

                    @if ($data->information != null)
                        @foreach ($data->convertAutoData() as $pkey => $pdata)
                            @if ($pkey == 'sandbox_check')
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="pkey[{{ __($pkey) }}]"
                                               class="custom-control-input" {{ $pdata == 1 ? 'checked' : '' }}
                                               id="{{ $pkey }}">
                                        <label class="custom-control-label" for="{{ $pkey }}">
                                            {{ __($data->name . ' ' . ucwords(str_replace('_', ' ', $pkey))) }}
                                        </label>
                                    </div>
                                </div>
                            @else
                                <div class="form-group">
                                    <label
                                        for="inp-{{ __($pkey) }}">{{ __($data->name . ' ' . ucwords(str_replace('_', ' ', $pkey))) }}</label>
                                    <input type="text" class="form-control" id="inp-{{ __($pkey) }}"
                                           name="pkey[{{ __($pkey) }}]"
                                           placeholder="{{ __($data->name . ' ' . ucwords(str_replace('_', ' ', $pkey))) }}"
                                           value="{{ $pdata }}" required>
                                </div>
                            @endif
                        @endforeach
                    @endif

                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="deposit_switch" name="status"
                                {{ $data->status == 1 ? 'checked' : '' }}>
                            <label class="custom-control-label" for="deposit_switch">Deposit</label>
                        </div>
                    </div>
                @else
                    <div class="form-group">
                        <label for="inp-title">{{ __('Name') }}</label>
                        <input type="text" class="form-control" id="inp-title" name="title"
                               placeholder="{{ __('Enter Name') }}" value="{{ $data->title }}" required>
                    </div>

                    <div class="d-flex align-items-center" style="gap: 1.5rem">
                        <div class="form-group" style="flex-grow: 1">
                            <label for="title">{{ __('Logo') }}</label>
                            <input type="file" class="form-control form-control-file" id="logo" name="logo"/>
                        </div>
                        @if (!empty($data->logo))
                            <div class="mt-2">
                                <img src="{{ asset('assets/images/' . $data->logo) }}" alt="Logo" height="70"
                                     style="max-width: 100px"/>
                            </div>
                        @endif
                    </div>

                    <div class="form-group">
                        <label for="inp-subtitle">{{ __('Subtitle') }}</label>
                        <input type="text" class="form-control" id="inp-subtitle" name="subtitle"
                               placeholder="{{ __('Enter Subtitle') }}" value="{{ $data->subtitle }}" required>
                    </div>

                    <div class="form-group">
                        <label for="currency_id">{{ __('Currency') }}</label>
                        <select class="form-control js-example-basic-single mb-3" name="currency_id" required>
                            <option value="" selected>{{ __('Select Currency') }}</option>
                            @foreach ($currencies as $key => $currency)
                                <option
                                    value="{{ $currency->id }}" @selected($currency->id == $currency_id[0])>{{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>


                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="deposit_switch" name="status"
                                {{ $data->status == 1 ? 'checked' : '' }}>
                            <label class="custom-control-label" for="deposit_switch">Deposit</label>
                        </div>
                    </div>

                    <div class="d-none border rounded px-3 py-2 mb-4" id="deposit_settings">
                        <p class="font-weight-bold border-bottom mb-3">Deposit Settings</p>

                        @if ($data->keyword == null)
                            <div class="form-group">
                                <label for="inp-details">{{ __('Description') }}</label>
                                <textarea name="details" class="form-control summernote" id="inp-details" cols="30"
                                          rows="10">{{ $data->details }}</textarea>
                            </div>
                        @endif

                        <div class="lang-tag-top-filds mt-4" id="lang-section">
                            <label for="instruction">{{ __('Additional Information') }}</label>
                            @if (!empty($additionalFields))
                                @foreach ($additionalFields as $key => $info)
                                    <div class="lang-area mb-3">
                                        <span class="remove lang-remove"><i class="fas fa-times"></i></span>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="text"
                                                       name="form_builder[{{ $key }}][field_name]"
                                                       class="form-control" placeholder="{{ __('Field Name') }}"
                                                       value="{{ $info['field_name'] }}">
                                            </div>

                                            <div class="col-md-3">
                                                <select name="form_builder[{{ $key }}][type]"
                                                        class="form-control">
                                                    <option value="text"
                                                        {{ $info['type'] == 'text' ? 'selected' : '' }}>
                                                        {{ __('Input') }} </option>
                                                    <option value="textarea"
                                                        {{ $info['type'] == 'textarea' ? 'selected' : '' }}>
                                                        {{ __('Textarea') }} </option>
                                                    <option value="file"
                                                        {{ $info['type'] == 'file' ? 'selected' : '' }}>
                                                        {{ __('File upload') }} </option>
                                                </select>
                                            </div>

                                            <div class="col-md-3">
                                                <select name="form_builder[{{ $key }}][validation]"
                                                        class="form-control">
                                                    <option value="required"
                                                        {{ $info['validation'] == 'required' ? 'selected' : '' }}>
                                                        {{ __('Required') }} </option>
                                                    <option value="nullable"
                                                        {{ $info['validation'] == 'nullable' ? 'selected' : '' }}>
                                                        {{ __('Optional') }} </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>

                        <div class="mb-3">
                            <a href="javascript:void(0);" id="lang-btn" class="add-fild-btn">&plus;
                                {{ __('Add More Field') }}</a>
                        </div>
                    </div>
                @endif


                <div class="form-group">
                    <div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input" id="withdraw_switch" name="withdraw_status"
                            @checked($data->withdraw_status == 1)>
                        <label class="custom-control-label" for="withdraw_switch">Withdraw</label>
                    </div>
                </div>

                <div class="d-none border rounded px-3 py-2 mb-4" id="withdraw_settings">
                    <p class="font-weight-bold border-bottom mb-3">Withdraw Settings</p>

                    <div class="form-group">
                        <label for="withdraw_note">{{ __('Withdraw Note') }}</label>
                        <textarea class="form-control summernote" id="withdraw_note" name="withdraw_note" rows="3"
                                  placeholder="{{ __('Withdraw Note') }}">{{ $data->withdraw_note }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="inp-fixed">{{ __('Withdraw Fixed Fee') }}
                            <small>({{ __('Leave 0 if you don\'t want to add fee') }})</small></label>
                        <input type="text" class="form-control" id="inp-fixed" name="withdraw_fee_fixed" step="any"
                               value="{{ $data->withdraw_fee_fixed }}" placeholder="{{ __('Withdraw Fixed Fee') }}"/>
                    </div>

                    <div class="form-group">
                        <label for="inp-percentage">{{ __('Withdraw Percentage Charge') }}
                            <small>({{ __('Leave 0 if you don\'t want to add fee') }})</small></label>
                        <input type="text" class="form-control" id="inp-percentage" name="withdraw_fee_percentage"
                               value="{{ $data->withdraw_fee_percentage }}" step="any"
                               placeholder="{{ __('Withdraw Percentage Charge') }}"/>
                    </div>
                </div>

                <div class="py-2">
                    <p class="font-weight-bold border-bottom mb-3">Fund Settings</p>

                    <div class="form-group">
                        <label for="fund_note">{{ __('Note') }}</label>
                        <textarea class="form-control summernote" id="fund_note" name="fund_note" required rows="3"
                                  placeholder="{{ __('Fund Note') }}">{{ $data->fund_note }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="fund_available">{{ __('Available Amount') }}</label>
                        <input type="number" class="form-control" id="fund_available" step="any"
                               value="{{ $data->fund_available }}" placeholder="{{ __('Available Amount') }}"
                               name="fund_available" required/>
                    </div>

                    <div class="form-group">
                        <label for="sending_rate">{{ __('Sending Rate') }}</label>
                        <input type="number" class="form-control" id="sending_rate" value="{{ $data->sending_rate }}"
                               placeholder="{{ __('Sending Rate') }}" name="sending_rate" step="any" required/>
                    </div>

                    <div class="form-group">
                        <label for="receiving_rate">{{ __('Receiving Rate') }}</label>
                        <input type="number" class="form-control" id="receiving_rate"
                               value="{{ $data->receiving_rate }}" placeholder="{{ __('Receiving Rate') }}"
                               name="receiving_rate" step="any" required/>
                    </div>

                    <div class="form-group">
                        <label for="min_limit">{{ __('Minimum Limit') }}</label>
                        <input type="number" class="form-control" id="min_limit" value="{{ $data->min_limit }}"
                               placeholder="{{ __('Minimum Limit') }}" name="min_limit" step="any" required/>
                    </div>

                    <div class="form-group">
                        <label for="max_limit">{{ __('Maximum Limit') }}</label>
                        <input type="number" class="form-control" id="max_limit" value="{{ $data->max_limit }}"
                               placeholder="{{ __('Maximum Limit') }}" name="max_limit" step="any" required/>
                    </div>

                          <div class="form-group">   
                                <label for="deposit_charge">{{ __('Deposit Charge Percent') }} (Percent)</label>
                                <input type="text" class="form-control" id="deposit_charge" step="any"
                                    placeholder="{{ __('Deposit Charge Percent') }}" name="deposit_charge" value="{{ $data->deposit_charge }}" required>
                            </div>

                              <div class="form-group">   
                                <label for="deposit_charge_fix">{{ __('Deposit Charge Fix') }}</label>
                                <input type="text" class="form-control" id="deposit_charge_fix" step="any"
                                    placeholder="{{ __('Deposit Charge  fix') }}" name="deposit_charge_fix" value="{{ $data->deposit_charge_fix }}" required>
                            </div>

                </div>

                <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
            </form>
        </div>
    </div>

@endsection

@section('scripts')
    <script type="text/javascript">
        'use strict';

        function isEmpty(el) {
            return !$.trim(el.html())
        }

        let id = 1;

        $("#lang-btn").on('click', function () {

            $("#lang-section").append(`<div class="lang-area mb-3">
          <span class="remove lang-remove"><i class="fas fa-times"></i></span>
          <div class="row">
            <div class="col-md-6">
              <input type="text" name="form_builder[${id}][field_name]" class="form-control" placeholder="{{ __('Field Name') }}">
            </div>

            <div class="col-md-3">
              <select name="form_builder[${id}][type]" class="form-control">
                  <option value="text"> Input </option>
                  <option value="textarea"> Textarea </option>
                  <option value="file"> File upload </option>
              </select>
            </div>

            <div class="col-md-3">
              <select name="form_builder[${id}][validation]" class="form-control">
                  <option value="required"> Required </option>
                  <option value="nullable">  Optional </option>
              </select>
            </div>
          </div>
      </div>`);
            id++;
        });

        $(document).on('click', '.lang-remove', function () {

            $(this.parentNode).remove();
            if (id && id > 1) {
                id--;
            }
            if (isEmpty($('#lang-section'))) {

                $("#lang-section").append(`<div class="lang-area mb-3">
            <span class="remove lang-remove"><i class="fas fa-times"></i></span>
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="form_builder[1][field_name]" class="form-control" placeholder="{{ __('Field Name') }}">
              </div>

              <div class="col-md-3">
                <select name="form_builder[1][type]" class="form-control">
                    <option value="text"> Input </option>
                    <option value="textarea"> Textarea </option>
                    <option value="file"> File upload </option>
                </select>
              </div>

              <div class="col-md-3">
                <select name="form_builder[1][validation]" class="form-control">
                    <option value="required"> Required </option>
                    <option value="nullable">  Optional </option>
                </select>
              </div>
            </div>
          </div>`);
            }

        });

        $(document).on('change', '#withdraw_switch', function () {
            if ($(this).is(':checked')) {
                $('#withdraw_settings').removeClass('d-none');
            } else {
                $('#withdraw_settings').addClass('d-none');
            }
        });

        $(document).on('change', '#deposit_switch', function () {
            if ($(this).is(':checked')) {
                $('#deposit_settings').removeClass('d-none');
            } else {
                $('#deposit_settings').addClass('d-none');
            }
        });

        @if ($data->status == 1)
        $('#deposit_settings').removeClass('d-none');
        @endif

        @if ($data->withdraw_status == 1)
        $('#withdraw_settings').removeClass('d-none');
        @endif
    </script>
@endsection
