@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Meta Keywords') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('SEO Tools') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.seotool.keywords') }}">{{ __('Meta Keywords') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="card mb-4 mt-3">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        </div>

        <div class="card-body">
            <div class="gocover"
                style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
            </div>
            <form class="geniusform" action="{{ route('admin.seotool.analytics.update') }}" method="POST"
                enctype="multipart/form-data">

                @include('includes.admin.form-both')

                {{ csrf_field() }}

                <div class="form-group">
                    <label for="inp-name">{{ __('Meta Keywords') }} *</label>
                    <textarea name="meta_keys" class="form-control summernote" rows="5">{{ $tool->meta_keys }}</textarea>
                </div>

                <div class="form-group">
                    <label for="inp-name">{{ __('Meta Description') }} *</label>
                    <textarea name="meta_description" class="form-control" rows="5">{{ $tool->meta_description }}</textarea>
                </div>

                <div class="form-group">
                    <label for="inp-name">{{ __('Social Title') }} *</label>
                    {{-- <textarea name="meta_keys" class="form-control summernote"
                              rows="5">{{ $tool->meta_keys }}</textarea> --}}
                    <input type="text" name="social_title" class="form-control" value="{{ $tool->social_title }}">
                </div>

                     <div class="form-group">
                    <label for="inp-name">{{ __('GTM ID') }} </label>
                    {{-- <textarea name="meta_keys" class="form-control summernote"
                              rows="5">{{ $tool->meta_keys }}</textarea> --}}
                    <input type="text" name="gtm_id" class="form-control" value="{{ $tool->gtm_id }}">
                </div>

                     <div class="form-group">
                    <label for="inp-name">{{ __('Facebook Pixel Id') }} </label>
                    {{-- <textarea name="meta_keys" class="form-control summernote"
                              rows="5">{{ $tool->meta_keys }}</textarea> --}}
                    <input type="text" name="facebook_pixel_id" class="form-control" value="{{ $tool->facebook_pixel_id }}">
                </div>


                <div class="form-group">
                    <label for="social_description">{{ __('Social Description') }} *</label>
                    <textarea name="social_description" class="form-control " rows="3">{{ $tool->social_description }}</textarea>
                </div>

                                  <div class="form-group">
                                <div class="wrapper-image-preview-settings">
                                    <div class="box-settings">
                                        <div class="back-preview-image"
                                             style="background-image: url({{ $tool->logo ? asset('assets/images/'.$tool->logo):asset('assets/images/placeholder.jpg') }});"></div>
                                        <div class="upload-options-settings">
                                            <label class="img-upload-label" for="img-upload-1">
                                                <i class="fas fa-camera"></i> {{ __('Upload Picture') }}
                                                <br>
                                            </label>
                                            <input id="img-upload-1" type="file" class="image-upload" name="logo"
                                                   accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div> 

                <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
            </form>
        </div>
    </div>
@endsection
