@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class="mb-0 text-gray-800 pl-3">{{ __('Live Chat  Settings') }}</h5>
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Settings') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('tawk.script') }}">{{ __('Live chat') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4 mt-3">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Live Chat Management') }}</h6>
                </div>

                <div class="card-body">
                    <form class="geniusform" action="{{ route('admin.tawk.script.update') }}" method="POST"
                          enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label for="whatsapp_tawk_enabled">{{ __('Enable Tawk to  ') }}</label>
                            <select name="whatsapp_tawk_enabled" class="form-control">
                                <option
                                    value="1" {{ $script->whatsapp_tawk_enabled ? 'selected' : '' }}>{{ __('Enabled') }}</option>
                                <option
                                    value="0" {{ !$script->whatsapp_tawk_enabled ? 'selected' : '' }}>{{ __('Disabled') }}</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="whatsapp_tawk_script">{{ __('Tawk  To Chat') }}</label>
                            <textarea name="whatsapp_tawk_script" class="form-control"
                                      rows="6">{{ old('whatsapp_tawk_script', $script->whatsapp_tawk_script) }}</textarea>
                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="messenger_tawk_enabled">{{ __('Enable Messenger Chat') }}</label>
                            <select name="messenger_tawk_enabled" class="form-control">
                                <option
                                    value="1" {{ $script->messenger_tawk_enabled ? 'selected' : '' }}>{{ __('Enabled') }}</option>
                                <option
                                    value="0" {{ !$script->messenger_tawk_enabled ? 'selected' : '' }}>{{ __('Disabled') }}</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="messenger_tawk_script">{{ __('Messenger Chat') }}</label>
                            <textarea name="messenger_tawk_script" class="form-control"
                                      rows="6">{{ old('messenger_tawk_script', $script->messenger_tawk_script) }}</textarea>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">{{ __('Update Chat Settings') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
