<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Other Bank Transfer</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
            padding: 0;
            margin: 0;
            outline: 0;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        table,
        th,
        td {
            border: 1px solid #4f4f4f;
            padding: 4px 5px;
            line-height: 1 !important;
        }

        .text-center {
            text-align: center;
        }

        .text-end {
            text-align: right;
        }

        .text-title {
            font-size: 1.5rem;
            padding-top: 5px
        }

        .text-subtitle {
            font-size: 1.25rem;
            padding-top: 5px
        }

        .w-1 {
            width: 1%;
        }
    </style>
</head>

<body>
    <div style="padding: 30px;">
        <div style="padding-bottom: 20px">
            <h2 class="text-center text-title">{{ $title }}</h2>
            <h4 class="text-center text-subtitle">Other Bank Transfer</h4>
            {{-- <p class="text-center" style="font-size: 1.25rem; padding-top: 5px">Period: {{ request('from') }}
            to {{ request('to') }}</p> --}}
        </div>
        <table>
            <thead>
                <tr>
                    <th class="w-1 text-center">@lang('S/N')</th>
                    <th>@lang('Transaction no')</th>
                    <th>@lang('Transfer From')</th>
                    <th>@lang('Transfer To Account')</th>
                    <th>@lang('Transfer To Bank')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Cost')</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $total_amount = 0;
                    $total_value = 0;
                @endphp
                @forelse ($transfers as $key=>$data)
                    @php
                        $total_amount += $data->amount;
                        $total_value += $data->cost;
                    @endphp
                    <tr>
                        <td class="w-1 text-center" data-label="@lang('No')">
                            <div>
                                <span class="text-muted">{{ $loop->iteration }}</span>
                            </div>
                        </td>

                        <td data-label="@lang('Transaction no')">
                            <div>
                                {{ $data->transaction_no}}
                            </div>
                        </td>

                        <td data-label="@lang('Transfer From')">
                            <div>
                                {{ $data->user->name .' '. $data->user->last_name ?? '-'}}
                                <br>
                                {{ $data->user->account_number ?? '-'}}
                            </div>
                        </td>


                        <td data-label="@lang('Transfer To Account')">
                            {{ $data->beneficiary->account_name ?? '-'}}
                            <br>
                            {{ $data->beneficiary->account_number ?? '-'}}
                        </td>

                        <td data-label="@lang('Transfer To Bank')">
                            {{ $data->bank->title ?? '-'}}
                        </td>
                        <td data-label="@lang('Amount')" class="text-end">
                            {{ $currency->sign }}{{ $data->amount  }}
                        </td>

                        <td data-label="@lang('Cost')" class="text-end">
                            {{ $currency->sign }}{{ $data->cost  }}
                        </td>
                    </tr>
                @empty
                    <p>@lang('NO DATA FOUND')</p>
                @endforelse
            </tbody>
            @if ($transfers->count() > 0)
                <tfoot>
                    <tr>
                        <th colspan="5" class="text-end">@lang('Total'):</th>
                        <th class="text-end">{{ number_format($total_amount, 2) }}</th>
                        <th class="text-end">{{ number_format($total_value, 2) }}</th>
                    </tr>
                </tfoot>
            @endif
        </table>
    </div>
</body>
</html>