<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Wire Transfer</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
            padding: 0;
            margin: 0;
            outline: 0;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        table,
        th,
        td {
            border: 1px solid #4f4f4f;
            padding: 4px 5px;
            line-height: 1 !important;
        }

        .text-center {
            text-align: center;
        }

        .text-end {
            text-align: right;
        }

        .text-title {
            font-size: 1.5rem;
            padding-top: 5px
        }

        .text-subtitle {
            font-size: 1.25rem;
            padding-top: 5px
        }

        .w-1 {
            width: 1%;
        }
    </style>
</head>

<body>
    <div style="padding: 30px;">
        <div style="padding-bottom: 20px">
            <h2 class="text-center text-title">{{ $title }}</h2>
            <h4 class="text-center text-subtitle">Wire Transfer</h4>
            {{-- <p class="text-center" style="font-size: 1.25rem; padding-top: 5px">Period: {{ request('from') }}
            to {{ request('to') }}</p> --}}
        </div>
        <table>
            <thead>
                <tr>
                    <th class="w-1 text-center">@lang('S/N')</th>
                    <th>@lang('Transaction No')</th>
                    <th>@lang('Bank Name')</th>
                    <th>@lang('Transfer From')</th>
                    <th>@lang('Transaction no')</th>
                    <th>@lang('Country')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Charge')</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $total_amount = 0;
                    $total_value = 0;
                @endphp

                @forelse ($wire_transfers as $key => $data)
                    @php
                        $total_amount += $data->amount;
                        $total_value += $data->charge;
                    @endphp
                    <tr>
                        <td class="w-1 text-center">
                            <span class="text-muted">{{ $loop->iteration }}</span>
                        </td>
                        <td>{{ $data->transaction_no }}</td>
                        <td>{{ optional($data->bank)->title}}</td>
                        <td>
                            {{ $data->user->name }}
                            <br>
                            {{ $data->user->account_number ?? '-'}}
                        </td>
                        <td>
                            {{ $data->account_holder_name ?? '-'}}
                            <br>
                            {{ $data->account_number ?? '-'}}
                        </td>
                        <td>{{ $data->country }}</td>
                        <td class="text-end">{{ $currency->sign }}{{ $data->amount  }}</td>
                        <td class="text-end">{{ $currency->sign }}{{ $data->charge  }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted">@lang('NO DATA FOUND')</td>
                    </tr>
                @endforelse
            </tbody>

            @if ($wire_transfers->count() > 0)
                <tfoot>
                    <tr>
                        <th colspan="6" class="text-end">@lang('Total'):</th>
                        <th class="text-end">{{ number_format($total_amount, 2) }}</th>
                        <th class="text-end">{{ number_format($total_value, 2) }}</th>
                    </tr>
                </tfoot>
            @endif
        </table>

    </div>
</body>
</html>
