@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Withdraw Request') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>

                <li class="breadcrumb-item"><a href="{{ route('admin.user.index') }}">{{ __('Withdraw Request') }}</a>
                </li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <!-- Datatables -->
        <div class="col-lg-12">

            @include('includes.admin.form-success')
            <div class="row g-3 mb-3">
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $pending ?? 0 }}</div>
                            <div class="text-muted">{{ __('Pending') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $complete ?? 0 }}</div>
                            <div class="text-muted">{{ __('Complete') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $cancelled ?? 0 }}</div>
                            <div class="text-muted">{{ __('Cancelled') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $processing ?? 0 }}</div>
                            <div class="text-muted">{{ __('Processing') }}</div>
                        </div>
                    </div>
                </div>
                <div class="col mb-3">
                    <div class="card card-sm shadow-sm">
                        <div class="card-body text-center">
                            <div class="text-h2">{{ $onhold ?? 0 }}</div>
                            <div class="text-muted">{{ __('On Hold') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mb-4">
                <div>
                    <a id="print-selected" target="_blank" class="btn btn-primary mx-4 mt-2"
                        href="{{ route('admin.withdraw.pdfprint') }}"> Print </a>
                </div>
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr class="dt-column-filter">
                                <th class="">-</th>
                                <th>
                                    <input type="search" class="form-control" placeholder="Search" />
                                </th>
                                <th>
                                    <input type="search" class="form-control" placeholder="Search" />
                                </th>
                                <th class="text-center">
                                    <input type="search" class="form-control" placeholder="Search" />
                                </th>
                                <th>
                                    <select type="text" class="form-control ">
                                        <option value="">All</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Stripe">Stripe</option>
                                        <option value="Paypal">Paypal</option>
                                    </select>
                                </th>
                                <th>
                                    <input type="search" class="form-control" placeholder="Search" />
                                </th>
                                <th>
                                    <select type="text" class="form-control ">
                                        <option value="">All</option>
                                        <option value="pending">Pending</option>
                                        <option value="processing">Processing</option>
                                        <option value="completed">Completed</option>
                                        <option value="hold">Hold</option>
                                        <option value="rejected">Rejected</option>

                                    </select>
                                </th>
                                <th>
                                </th>
                                <th>
                                </th>
                            </tr>
                            <tr>
                                <th><input type="checkbox" id="select-all"></th>
                                <th> {{ __('Email') }}</th>
                                <th> {{ __('Phone') }} </th>
                                <th> {{ __('Amount') }} </th>
                                <th> {{ __('Method') }}</th>
                                <th> {{ __('Date') }}</th>
                                <th> {{ __('Status') }} </th>
                                <th> {{ __('Last Status') }} </th>
                                <th> {{ __('Actions') }} </th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!-- DataTable with Hover -->

    </div>
    <!--Row-->

    <div class="modal fade confirm-modal" id="details" tabindex="-1" role="dialog" aria-labelledby="statusModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Withdraw Request Details') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Back') }}</a>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade confirm-modal" id="status-modal" tabindex="-1" role="dialog" aria-labelledby="modal1"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-block text-center">
                    <h4 class="modal-title d-inline-block">{{ __('Accpet Withdraw') }}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to accept this Withdraw.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-success btn-ok">{{ __('Accept') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- <div class="modal fade status-modal" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="modal1"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header d-block text-center">
                    <h4 class="modal-title d-inline-block">{{ __('Reject Withdraw') }}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to reject this Withdraw.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger btn-ok">{{ __('Reject') }}</a>
                </div>

            </div>
        </div>
    </div> --}}
@endsection


@section('scripts')
    <script type="text/javascript">
        "use strict";
        var table = $('#geniustable').DataTable({
            ordering: true,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin.withdraw.datatables') }}',
            columns: [{
                    data: 'checkbox',
                    name: 'checkbox',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'email',
                    name: 'email',
                    orderable: false
                },
                {
                    data: 'phone',
                    name: 'phone',
                    orderable: false
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
                {
                    data: 'method',
                    name: 'method'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'status',
                    // searchable: false,
                    orderable: true
                },
                {
                    data: 'last_history',
                    // searchable: false,
                    orderable: false
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                },
            ],
            order: [
                [5, 'asc'],
                [4, 'desc']
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });

        // Apply column filter
        $('#geniustable .dt-column-filter th').each(function(i) {
            $('input, select', this).on('keyup change', debounce(function() {
                if (table.column(i).search() !== this.value) {
                    table.column(i).search(this.value).draw()
                }
            }, 300)); // 300ms debounce delay
        });


        $(document).on('click', '#applicationDetails', function() {
            let detailsUrl = $(this).data('href');
            $.get(detailsUrl, function(data) {
                $("#details .modal-body").html(data);
            });
        })
    </script>

    <script>
        // Select all checkboxes
        $('#select-all').on('click', function() {
            const isChecked = $(this).is(':checked');
            $('.row-checkbox').prop('checked', isChecked);
            printSelectedIds();
        });

        // When any checkbox is clicked
        $(document).on('change', '.row-checkbox', function() {
            const allChecked = $('.row-checkbox').length === $('.row-checkbox:checked').length;
            $('#select-all').prop('checked', allChecked);
            printSelectedIds();
        });

        // Function to print selected IDs
        function printSelectedIds() {
            const ids = $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();
            console.log('Selected IDs:', ids);
        }
        // Select all checkboxes
        $('#select-all').on('click', function() {
            const isChecked = $(this).is(':checked');
            $('.row-checkbox').prop('checked', isChecked);
            printSelectedIds();
        });

        // When any checkbox is clicked
        $(document).on('change', '.row-checkbox', function() {
            const allChecked = $('.row-checkbox').length === $('.row-checkbox:checked').length;
            $('#select-all').prop('checked', allChecked);
            printSelectedIds();
        });

        // Function to print selected IDs
        function printSelectedIds() {
            const ids = $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

        }
    </script>

    <script>
        function getSelectedIds() {
            return $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();
        }

        $('#print-selected').on('click', function(e) {
            const ids = getSelectedIds();

            if (ids.length > 0) {
                const queryString = ids.map(id => `ids[]=${id}`).join('&');
                const baseUrl = `{{ route('admin.withdraw.pdfprint') }}`;
                const url = `${baseUrl}?${queryString}`;
                $(this).attr('href', url);
            } else {
                
                $(this).attr('href', `{{ route('admin.withdraw.pdfprint') }}`);
            }
            
        });
    </script>


@endsection
