<div>
    <div>
        <h3>How does it works?</h3>

        <div>
            We have a really simple process to work with our payment API. You will just need to submit a
            form to our payment request URL:
            <code class="cursor-pointer"
                  @click="$clipboard(String($el.textContent).trim());$dispatch('text-copied', 'URL')"
            >{{ route('payment.request') }}</code>
            with below form data and it will redirect you to our payment gateway.

            <x-payment-api.form-example :$merchant/>

            After payment completion, you will be redirected to your provided return URL with a payment
            response as query parameter. If the payment is canceled, you will be redirected to your provided cancel URL.
            On each successful payment, our server will send a POST request to your provided webhook URL (if provided)
            with payment response.
            <br>
            <br>
            <strong>Note:</strong> You can also use our payment API by sending a POST request to
            <code class="cursor-pointer"
                  @click="$clipboard(String($el.textContent).trim());$dispatch('text-copied', 'API URL')"
            >{{ route('payment.request.api') }}</code> which will return a response with payment link
            and you can redirect the customer to that link.

            <x-payment-api.api-example :$merchant/>
            <br>

            <div class="my-4 text-black">
                You can create an payment link manually from
                <a href="{{ route('user.payment-api.test') }}" target="_blank">here</a>.
            </div>
        </div>
    </div>
    <br>
    <br>
    <br>
</div>
