<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Solvency</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .content {
            margin-bottom: 20px;
            text-align: center;
        }
        .content h3 {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }
        .content p {
            font-size: 18px;
            margin: 5px 0;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 14px;
        }

        .signature {
            margin-top: 250px;
            margin-bottom: 30px;
            width: 100%;
        }

        .seal-signature {
            width: 45%;
            text-align: center;
            display: inline-block;
        }

        .left {
            float: left;
        }

        .right {
            float: right;
        }

        .seal-signature p {
            font-size: 14px;
            font-weight: bold;
            margin: 0;
        }
        
        .footer {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 50px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header" style="display: flex; align-items: center; justify-content: center; text-align: center; margin-bottom: 10px; position: relative;">
            <img src="{{ $company_logo }}" alt="Logo" style="height: 60px; margin-right: 15px;">
            <p style="font-size: 22px; font-weight: bold; margin: 0;">{{ $title }}</p>
            <p style="font-size: 14px; position: absolute; right: 0; top: 0; margin: 0;">
                Date: {{ now()->format('d-M-Y') }}
            </p>
        </div>

        <div class="content">
            <h4>ACCOUNT CERTIFICATE</h4>
            <p>To Whom It May Concern</p>
            <p style="text-align: left; margin-top:20px">This is to certify that the following customer has been maintaining the mentioned account with {{$title}}.</p>

            <table class="table">
                <tr>
                    <th>Type of Account</th>
                    <td>{{ucFirst($account_type)}}</td>
                </tr>
                <tr>
                    <th>Account Number</th>
                    <td>{{$account_number}}</td>
                </tr>
                <tr>
                    <th>Account Holder Name</th>
                    <td>{{$user_name}}</td>
                </tr>
                <tr>
                    <th>Account Opening Date</th>
                    <td>{{$account_opening_date}}</td>
                </tr>
                <tr>
                    <th>Account Currency</th>
                    <td>{{$currency_name}}</td>
                </tr>
                <tr>
                    <th>Balance as on <small>({{now()->format('d-M-Y')}})</small></th>
                    <td>{{$balance}}</td>
                </tr>
                <tr>
                    <th>Communication Address</th>
                    <td>{{$user_address}}</td>
                </tr>
                <tr>
                    <th>Mother's Name</th>
                    <td>-</td>
                </tr>
                <tr>
                    <th>Father's Name</th>
                    <td>-</td>
                </tr>
                <tr>
                    <th>Date of Birth</th>
                    <td>{{ \Carbon\Carbon::parse($dob)->format('d-M-Y') }}</td>
                </tr>
            </table>

            <p>This certificate has been issued upon request of the customer without any risk and responsibility to the bank or any of its official.</p>
        </div>

        <div class="signature">
            <div class="seal-signature left">
                <p>---------------------------------------</p>
                <p>Seal & Signature with Date</p>
            </div>
            <div class="seal-signature right">
                <p>---------------------------------------</p>
                <p>Seal & Signature with Date</p>
            </div>
        </div>

        <div class="footer">
            <p>Email: {{$email}}, Tel: {{$phone}}</p>
            <p>Website: {{url('/')}}</p>
        </div>
    </div>
</body>
</html>
