<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Statement - {{ $date }}</title>
    <style>
        /* General Styles */
            * {
                font-family: sans-serif;
                font-size: 12px;
                margin: 0;
                padding: 0;
            }

            body {
                padding: 15px 30px;
            }

            /* Header and Customer Info */
            .header, .customer-info, .account-info {
                display: flex;
                justify-content: space-between;
                margin-bottom: 10px;
            }

            .logo img {
                width: 120px;
            }

            .text-right { text-align: right; }
            .text-center { text-align: center; }

            /* Titles */
            h3, h4 {
                margin: 0;
            }

            .title {
                margin-bottom: 10px;
            }

            /* Table Styling */
            table {
                width: 100% !important;
                border-collapse: collapse;
                table-layout: fixed; /* allows columns to shrink and wrap */
            }

            table th, table td {
                border: 1px solid #000;
                padding: 3px 5px;
                font-size: 10px;
                word-wrap: break-word;
                overflow-wrap: break-word;
                white-space: normal; /* allow wrapping */
            }

            table th {
                background: #f0f0f0;
                text-align: center;
            }

            /* Optional compact styling for dense tables */
            .table-compact th, .table-compact td {
                font-size: 10px;
                padding: 3px 5px;
            }

            /* Column widths (adjust to fit A4 landscape) */
            table th:nth-child(1)  { width: 3%; }   /* S/N */
            table th:nth-child(2)  { width: 10%; }  /* Date */
            table th:nth-child(3)  { width: 12%; }  /* Type */
            table th:nth-child(4)  { width: 10%; }  /* Txnid */
            table th:nth-child(5)  { width: 10%; }  /* Sender */
            table th:nth-child(6)  { width: 10%; }  /* Receiver */
            table th:nth-child(7)  { width: 8%; }   /* Debit */
            table th:nth-child(8)  { width: 8%; }   /* Credit */
            table th:nth-child(9)  { width: 8%; }   /* Charge */
            table th:nth-child(10) { width: 21%; }  /* Available Balance */

    </style>
</head>
<body>
    <div class="header">
        <div class="logo">
            <img src="{{ $company_logo }}" alt="{{$title}}">
        </div>
        <div class="text-right">
            <h3>Statement of Account</h3>
            <p style="margin:10px 0 0 0;"><strong>{{ $title }}</strong></p>
            <p style="margin:2px 0;"><strong>Phone:</strong> {{ $phone }}</p>
            <p style="margin:2px 0;"><strong>Email:</strong> {{ $email }}</p>
        </div>
    </div> 

    <div class="customer-info">
        <div>
            <p><strong>{{$user_name}}</strong></p>
            <p>{{$user_address}}</p>
            {{-- <p><strong>Phone:</strong> {{$user_phone ?? 'N/A'}}</p> --}}
            <p><strong>Account Number:</strong> {{$account_number ?? 'N/A'}}</p>
            <p><strong>Account Type:</strong> {{ucFirst($account_type ?? 'N/A')}}</p>
        </div>
        <div class="text-right">
            <p><strong>Print Date:</strong> {{ date('d-M-Y') }}</p>
            <p><strong>Period From:</strong> {{ \Carbon\Carbon::parse(request('from'))->format('d-M-Y') }}</p>
            <p><strong>Period To:</strong> {{ \Carbon\Carbon::parse(request('to'))->format('d-M-Y') }}</p>
            <p><strong>Currency:</strong> {{ $currency_name }}</p>
        </div>
    </div>

    <div class="title">
        <h4 class="text-center">ACCOUNT ACTIVITY</h4>
    </div>

    <table class="table table-compact">
        <thead>
        <tr>
            <th>@lang('S/N')</th>
            <th>@lang('Date')</th>
            <th>@lang('Type')</th>
            <th>@lang('Txnid')</th>
            <th>@lang('Sender')</th>
            <th>@lang('Receiver')</th>
            <th>@lang('Debit')</th>
            <th>@lang('Credit')</th>
            <th>@lang('Charge')</th>
            <th>@lang('Available Balance')</th>
        </tr>
        </thead>
        <tbody>
            @forelse ($transactions as $key => $data)
                <tr style="white-space: nowrap; font-size: 13px; line-height: 1.2;">
                <td>{{ $loop->iteration }}</td>
                <td>{{date('d M Y',strtotime($data->created_at))}}</td>

                <td>{{ strtoupper($data->type) }}</td>

                <td>{{ $data->txnid }}</td>
                <td>{{ $data->sender_user ? $data->sender_user->account_number : '-' }}</td>
                <td>{{ $data->receiver_user ? $data->receiver_user->account_number : '-' }}</td>

                <td class="text-end">
                    {{ $data->profit !== 'plus' ? showprice($data->amount, $currency) : '0.00' }}
                </td>

                <td class="text-end">
                    {{ $data->profit === 'plus' ? showprice($data->amount, $currency) : '0.00' }}
                </td>

                <td class="text-end">
                    {{ auth()->user()->id == $data->user_id ?  showprice($data->charge, $currency)   : "0.00" }}
                </td>

                <td class="text-end">
                    {{ auth()->user()->id == $data->user_id ?   strtoupper($data->user_available_balance)  : strtoupper($data->receiver_available_balance) }}
                </td>
            </tr>

            @empty
                <tr>
                    <td colspan="6" class="text-center">@lang('NO DATA FOUND')</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>