<div
    class="form-group mb-3"
    x-data="{
        fileSelected(event) {
            let file = event.target.files[0];
            let reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = (e) => {
                $refs.merchant_logo.src = e.target.result;
            };
            this.isFileSelected = true;
        },
        isFileSelected: false,
    }"
>
    @csrf
    <label class="form-label">Merchant Logo</label>
    <input type="file" class="d-none" name="merchant_logo" x-ref="merchant_logo_input" @change="fileSelected"
           accept="image/png,image/gif,image/jpeg"/>
    <div style="width: 125px; height: 125px;" class="mb-2">
        <img src="{{ $merchant->merchant_logo_url }}" alt="Merchant Logo"
             class="img-thumbnail" x-ref="merchant_logo"/>
    </div>
    <button
        class="btn" type="button"
        @click="$refs.merchant_logo_input.click()"
        x-show="!isFileSelected"
    >
        Change Logo
    </button>
    <button class="btn btn-primary" form="upload_logo_form" x-show="isFileSelected" x-cloak>
        <span class="htmx-hide">Upload Logo</span>
        <span class="htmx-indicator">
            <span class="spinner-border spinner-border-sm me-1"></span>
            Uploading..
        </span>
    </button>
</div>
