<form action="{{ route('payment.process', [$paymentRequest->id], absolute: false) }}" method="POST"
      x-data="{ submitting: false }" @submit="submitting=true">
    @csrf
    <div class="text-center mb-3">
        <img src="{{asset('assets/images/'.$gs->logo)}}" width="110" height="32" alt="Logo"
             class="payment-logo"/>
    </div>
    <div class="text-center mb-3">
        <h3>Welcome, {{$user->name}}</h3>
        <p>Please confirm your payment</p>
    </div>

    <div class="my-2 text-center">
        Your available balance is <strong>{{ amount_format($user->balance) }}</strong>
    </div>

    <div class="border rounded-3 p-2 mb-3">
        <div class="text-center text-muted">Total Amount</div>
        <div class="text-center text-h1">
            <strong>{{ amount_format($paymentRequest->amount) }} {{ $paymentRequest->currency }}</strong>
        </div>
    </div>

    @if($user->balance < $paymentRequest->amount)
        <div class="text-warning mb-2">
            You are logged in, <br>but you don't have enough balance to pay. <br>
            <small>Please top up your account first.</small>
        </div>
    @else
        <button class="btn btn-primary w-100" :disabled="submitting">Confirm Payment</button>
    @endif
    <div class="mt-3">
        <button type="button" class="btn text-secondary border-0 w-100" data-bs-dismiss="modal" :disabled="submitting">
            Cancel
        </button>
    </div>
</form>
