@extends('layouts.user')

@push('css')

@endpush

@section('contents')

    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="d-flex flex-wrap justify-content-between">
                <div class="me-3">
                    <div class="page-pretitle">
                        {{__('Overview')}}
                    </div>
                    <h2 class="page-title">
                        {{__('Deposits')}}
                    </h2>
                </div>
                @if(!empty($gs->deposit_notice))
                    <div class="alert alert-warning">
                        <div class="text-danger">
                            {{__($gs->deposit_notice)}}
                        </div>
                    </div>
                @endif
                <div class="d-print-none">
                    <div class="btn-list">
                        <div class="btn-list">
                            {{-- Desktop button (visible on sm and larger screens) --}}
                            <a href="{{ route('user.deposit.create') }}"
                            class="btn btn-primary d-none d-sm-inline-block {{ !$isImpersonation ? '' : 'disabled' }}"
                            @disabled($isImpersonation)
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                {{ __('Create new Deposit') }}
                            </a>

                            {{-- Mobile button (only visible on xs screens) --}}
                            <a href="{{ route('user.deposit.create') }}"
                            class="btn btn-primary d-sm-none {{ !$isImpersonation ? '' : 'disabled' }}"
                            @disabled($isImpersonation)
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-5 g-3 mb-3">
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2">{{ $pending ?? 0 }}</div>
                                    <div class="text-muted">{{__('Pending')}}</div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2">{{ $complete ?? 0 }}</div>
                                    <div class="text-muted">{{__('Complete')}}</div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2">{{ $cancelled ?? 0 }}</div>
                                    <div class="text-muted">{{__('Cancelled')}}</div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2">{{ $processing ?? 0 }}</div>
                                    <div class="text-muted">{{__('Processing')}}</div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2">{{ $onhold ?? 0 }}</div>
                                    <div class="text-muted">{{__('On Hold')}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card">
                        @if (count($deposits) == 0)
                            <h3 class="text-center py-5">{{__('No Deposit Data Found')}}</h3>
                        @else
                            <div class="table-responsive">
                                <table class="table table-vcenter table-mobile-md card-table">
                                    <thead>
                                    <tr>
                                        <th>{{ __('Deposit Date') }}</th>
                                        <th>{{ __('Method') }}</th>
                                        <th>{{ __('Account') }}</th>
                                        <th>{{ __('Amount') }}</th>
                                        <th>{{ __('Status') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($deposits as $deposit)
                                        <tr>
                                            <td data-label="{{ __('Deposit Date') }}">
                                                <div>
                                                    {{date('d-M-Y',strtotime($deposit->created_at))}}
                                                </div>
                                            </td>
                                            <td data-label="{{ __('Method') }}">
                                                <div>
                                                    @if($deposit->method=='Manual' && $deposit->gateway?->title)
                                                        {{$deposit->gateway?->title}} ({{ $deposit->method }})
                                                    @else
                                                        {{ucwords($deposit->method)}}
                                                    @endif
                                                </div>
                                            </td>
                                            <td data-label="{{ __('Account') }}">
                                                <div>
                                                    {{ auth()->user()->email }}
                                                </div>
                                            </td>

                                            <td data-label="{{ __('Amount') }}">
                                                <div>
                                                    {{ showprice($deposit->amount,$currency) }}
                                                </div>
                                            </td>

                                            <td data-label="{{ __('Status') }}">
                                                <div>
                                                    {{ ucfirst($deposit->status) }}
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            {{ $deposits->links() }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')

@endpush

